/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.log.trace.reporter;

import cn.com.yusys.yusp.commons.log.common.util.LoggerSerializeUtils;
import cn.com.yusys.yusp.commons.log.trace.TraceLogger;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin2.Annotation;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.internal.JsonEscaper;
import zipkin2.reporter.Reporter;

public class TracingLoggerReporter
implements Reporter<Span> {
    private static final Logger log = LoggerFactory.getLogger(TracingLoggerReporter.class);

    public void report(Span span) {
        try {
            TraceLogger.info(this.span2Map(span));
        }
        catch (IOException e) {
            log.warn("record trace span info exception:{}", (Object)e.getMessage());
        }
    }

    Map<String, Object> span2Map(Span value) throws JsonProcessingException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("traceId", value.traceId());
        if (value.parentId() != null) {
            param.put("parentId", value.parentId());
        }
        param.put("id", value.id());
        if (value.kind() != null) {
            param.put("kind", value.kind().toString());
        }
        if (value.name() != null) {
            param.put("name", JsonEscaper.jsonEscape((CharSequence)value.name()));
        }
        if (value.timestampAsLong() != 0L) {
            long timestamp = value.timestampAsLong();
            param.put("timestamp", timestamp);
            long timestampMillis = Long.parseLong(String.valueOf(timestamp).substring(0, 13));
            param.put("timestampMillis", timestampMillis);
        }
        if (value.durationAsLong() != 0L) {
            param.put("duration", value.durationAsLong());
        }
        if (value.localEndpoint() != null) {
            param.put("localEndpoint", this.writeEndPoint(value.localEndpoint(), false));
        }
        if (value.remoteEndpoint() != null) {
            param.put("remoteEndpoint", this.writeEndPoint(value.remoteEndpoint(), false));
        }
        if (!value.annotations().isEmpty()) {
            param.put("annotations", TracingLoggerReporter.writeAnnotations(value.annotations()));
        }
        if (!value.tags().isEmpty()) {
            param.put("tags", LoggerSerializeUtils.writeAsString((Object)value.tags()));
        }
        if (Boolean.TRUE.equals(value.debug())) {
            param.put("debug", true);
        }
        if (Boolean.TRUE.equals(value.shared())) {
            param.put("shared", true);
        }
        return param;
    }

    Map<String, Object> writeEndPoint(Endpoint value, boolean writeEmptyServiceName) {
        int port;
        HashMap<String, Object> param = new HashMap<String, Object>();
        String serviceName = value.serviceName();
        if (serviceName == null && writeEmptyServiceName) {
            serviceName = "";
        }
        if (serviceName != null) {
            param.put("serviceName", serviceName);
        }
        if (value.ipv4() != null) {
            param.put("ipv4", value.ipv4());
        }
        if (value.ipv6() != null) {
            param.put("ipv6", value.ipv6());
        }
        if ((port = value.portAsInt()) != 0) {
            param.put("port", port);
        }
        return param;
    }

    static List<Map<String, Object>> writeAnnotations(List<Annotation> annotations) {
        ArrayList<Map<String, Object>> anna = new ArrayList<Map<String, Object>>();
        for (Annotation annotation : annotations) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("timestamp", annotation.timestamp());
            param.put("value", JsonEscaper.jsonEscape((CharSequence)annotation.value()));
            anna.add(param);
        }
        return anna;
    }
}

