/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.log.jvm.collect;

import cn.com.yusys.yusp.commons.log.common.collect.TimedCollector;
import cn.com.yusys.yusp.commons.log.jvm.JvmLogger;
import cn.com.yusys.yusp.commons.log.jvm.collect.LocalLogMetricsEndpoint;
import cn.com.yusys.yusp.commons.log.jvm.domain.ClassLoadingBean;
import cn.com.yusys.yusp.commons.log.jvm.domain.CompilationBean;
import cn.com.yusys.yusp.commons.log.jvm.domain.HeapMemoryUsage;
import cn.com.yusys.yusp.commons.log.jvm.domain.JvmMonitorEntity;
import cn.com.yusys.yusp.commons.log.jvm.domain.MemoryBean;
import cn.com.yusys.yusp.commons.log.jvm.domain.NonHeapMemoryUsage;
import cn.com.yusys.yusp.commons.log.jvm.domain.OperatingSystemBean;
import cn.com.yusys.yusp.commons.log.jvm.domain.RuntimeBean;
import cn.com.yusys.yusp.commons.log.jvm.domain.ThreadBean;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.google.gson.Gson;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.health.HealthComponent;
import org.springframework.boot.actuate.metrics.MetricsEndpoint;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;

public class JvmTimedCollector
implements TimedCollector {
    private static final Logger log = LoggerFactory.getLogger(JvmTimedCollector.class);
    private final String cron;
    private final LocalLogMetricsEndpoint localLogMetricsEndpoint;
    private final Gson gson;
    private static JvmMonitorEntity jvmMonitorEntity = JvmMonitorEntity.getJvmMonitorEntityInstance();
    private static final ClassLoadingBean CLASS_LOADING_BEAN = new ClassLoadingBean();
    private static final CompilationBean COMPILATION_BEAN = new CompilationBean();
    private static final OperatingSystemBean OPERATING_SYSTEM_BEAN = new OperatingSystemBean();
    private static final RuntimeBean RUNTIME_BEAN = new RuntimeBean();
    private static final ThreadBean THREAD_BEAN = new ThreadBean();
    private static final MemoryBean MEMORY_BEAN = new MemoryBean();
    private static final HeapMemoryUsage HEAP_MEMORY_USAGE_BEAN = new HeapMemoryUsage();
    private static final NonHeapMemoryUsage NON_HEAP_MEMORY_USAGE_BEAN = new NonHeapMemoryUsage();
    private static final ClassLoadingMXBean CLASS_LOADING_MX_BEAN = ManagementFactory.getClassLoadingMXBean();
    private static final CompilationMXBean COMPILATION_MX_BEAN = ManagementFactory.getCompilationMXBean();
    private static final MemoryMXBean MEMORY_MX_BEAN = ManagementFactory.getMemoryMXBean();
    private static final OperatingSystemMXBean OPERATING_SYSTEM_MX_BEAN = ManagementFactory.getOperatingSystemMXBean();
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private static final RuntimeMXBean RUNTIME_MX_BEAN = ManagementFactory.getRuntimeMXBean();
    private static final MemoryUsage HEAP_MEMORY_USAGE = MEMORY_MX_BEAN.getHeapMemoryUsage();
    private static final MemoryUsage NO_HEAP_MEMORY_USAGE = MEMORY_MX_BEAN.getNonHeapMemoryUsage();

    public JvmTimedCollector(String cron, LocalLogMetricsEndpoint localLogMetricsEndpoint) {
        this.cron = cron;
        this.localLogMetricsEndpoint = localLogMetricsEndpoint;
        this.gson = new Gson();
    }

    public Trigger getTrigger() {
        return new CronTrigger(this.cron);
    }

    public void run() {
        log.debug("begin to collect jvm  monitor data");
        JvmMonitorEntity jvmMonitorEntity = this.printJvmAllInfo();
        try {
            JvmLogger.info(jvmMonitorEntity);
        }
        catch (Exception e) {
            log.error("jvm monitor info get error", (Throwable)e);
        }
    }

    public JvmMonitorEntity printJvmAllInfo() {
        try {
            jvmMonitorEntity = this.printJvmInfo();
            if (jvmMonitorEntity != null) {
                Double processCpuUsage = this.localLogMetricsEndpoint.getMetricByProcessCpuUsage();
                jvmMonitorEntity.setProcessCpuUsage(processCpuUsage);
                Double systemCpuUsage = this.localLogMetricsEndpoint.getMetricBySystemCpuUsage();
                jvmMonitorEntity.setSystemCpuUsage(systemCpuUsage);
                MetricsEndpoint.MetricResponse gcMetricResponse = this.localLogMetricsEndpoint.getMetricByJvmGc();
                jvmMonitorEntity.setGcMetricResponse(gcMetricResponse);
                HealthComponent health = this.localLogMetricsEndpoint.getAppHealthStatus();
                jvmMonitorEntity.setHealth(this.gson.toJson((Object)health));
                Map<String, Object> infoMap = this.localLogMetricsEndpoint.getAppInfo();
                jvmMonitorEntity.setInfoMap(infoMap);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return jvmMonitorEntity;
    }

    public JvmMonitorEntity printJvmInfo() {
        try {
            CLASS_LOADING_BEAN.setLoadedClassCount(CLASS_LOADING_MX_BEAN.getLoadedClassCount());
            CLASS_LOADING_BEAN.setTotalLoadedClassCount(CLASS_LOADING_MX_BEAN.getTotalLoadedClassCount());
            CLASS_LOADING_BEAN.setUnloadedClassCount(CLASS_LOADING_MX_BEAN.getUnloadedClassCount());
            jvmMonitorEntity.setClassLoadingBean(CLASS_LOADING_BEAN);
            COMPILATION_BEAN.setName(COMPILATION_MX_BEAN.getName());
            if (COMPILATION_MX_BEAN.isCompilationTimeMonitoringSupported()) {
                COMPILATION_BEAN.setTotalCompilationTime(COMPILATION_MX_BEAN.getTotalCompilationTime());
            }
            jvmMonitorEntity.setCompilationBean(COMPILATION_BEAN);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        try {
            Double systemLoadAverage = OPERATING_SYSTEM_MX_BEAN.getSystemLoadAverage();
            BeanUtils.copyProperties((Object)OPERATING_SYSTEM_MX_BEAN, (Object)OPERATING_SYSTEM_BEAN);
            OPERATING_SYSTEM_BEAN.setSystemLoadAverage(systemLoadAverage);
            long totalPhysicalMemorySize = JvmTimedCollector.getLongFromOperatingSystem(OPERATING_SYSTEM_MX_BEAN, "getTotalPhysicalMemorySize");
            long freePhysicalMemorySize = JvmTimedCollector.getLongFromOperatingSystem(OPERATING_SYSTEM_MX_BEAN, "getFreePhysicalMemorySize");
            long usedPhysicalMemorySize = totalPhysicalMemorySize - freePhysicalMemorySize;
            long totalSwapSpaceSize = JvmTimedCollector.getLongFromOperatingSystem(OPERATING_SYSTEM_MX_BEAN, "getTotalSwapSpaceSize");
            long freeSwapSpaceSize = JvmTimedCollector.getLongFromOperatingSystem(OPERATING_SYSTEM_MX_BEAN, "getFreeSwapSpaceSize");
            long usedSwapSpaceSize = totalSwapSpaceSize - freeSwapSpaceSize;
            OPERATING_SYSTEM_BEAN.setTotalPhysicalMemorySize(totalPhysicalMemorySize);
            OPERATING_SYSTEM_BEAN.setFreePhysicalMemorySize(freePhysicalMemorySize);
            OPERATING_SYSTEM_BEAN.setUsedPhysicalMemorySize(usedPhysicalMemorySize);
            OPERATING_SYSTEM_BEAN.setTotalSwapSpaceSize(totalSwapSpaceSize);
            OPERATING_SYSTEM_BEAN.setUsedSwapSpaceSize(usedSwapSpaceSize);
            OPERATING_SYSTEM_BEAN.setFreeSwapSpaceSize(freeSwapSpaceSize);
            jvmMonitorEntity.setOperatingSystemBean(OPERATING_SYSTEM_BEAN);
            String pid = RUNTIME_MX_BEAN.getName().split("@")[0];
            if (StringUtils.nonEmpty((CharSequence)pid)) {
                RUNTIME_BEAN.setProcessId(pid);
            }
            float processUsage = this.localLogMetricsEndpoint.getMetricByProcessCpuUsage().floatValue();
            RUNTIME_BEAN.setProcessUsage(Float.valueOf(processUsage));
            BeanUtils.copyProperties((Object)RUNTIME_MX_BEAN, (Object)RUNTIME_BEAN);
            RUNTIME_BEAN.setInputArguments(this.gson.toJson(RUNTIME_MX_BEAN.getInputArguments()));
            jvmMonitorEntity.setRuntimeBean(RUNTIME_BEAN);
            BeanUtils.copyProperties((Object)THREAD_MX_BEAN, (Object)THREAD_BEAN);
            jvmMonitorEntity.setThreadBean(THREAD_BEAN);
        }
        catch (BeansException e) {
            log.error("", (Throwable)e);
        }
        BeanUtils.copyProperties((Object)HEAP_MEMORY_USAGE, (Object)HEAP_MEMORY_USAGE_BEAN);
        BeanUtils.copyProperties((Object)NO_HEAP_MEMORY_USAGE, (Object)NON_HEAP_MEMORY_USAGE_BEAN);
        try {
            Long userRate1 = HEAP_MEMORY_USAGE.getUsed() * 100L / HEAP_MEMORY_USAGE.getCommitted();
            HEAP_MEMORY_USAGE_BEAN.setUserRate(userRate1);
            Long userRate2 = NO_HEAP_MEMORY_USAGE.getUsed() * 100L / NO_HEAP_MEMORY_USAGE.getCommitted();
            NON_HEAP_MEMORY_USAGE_BEAN.setUserRate(userRate2);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        MEMORY_BEAN.setHeapMemoryUsage(HEAP_MEMORY_USAGE_BEAN);
        MEMORY_BEAN.setNonHeapMemoryUsage(NON_HEAP_MEMORY_USAGE_BEAN);
        jvmMonitorEntity.setMemoryBean(MEMORY_BEAN);
        jvmMonitorEntity.setTimestamp(System.currentTimeMillis());
        return jvmMonitorEntity;
    }

    private static long getLongFromOperatingSystem(OperatingSystemMXBean operatingSystem, String methodName) {
        try {
            Method method = operatingSystem.getClass().getMethod(methodName, null);
            method.setAccessible(true);
            return (Long)method.invoke((Object)operatingSystem, (Object[])null);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new IllegalStateException(e.getCause());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

