/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.log.dbpool.collect;

import cn.com.yusys.yusp.commons.log.common.collect.TimedCollector;
import cn.com.yusys.yusp.commons.log.dbpool.DbPoolLogger;
import cn.com.yusys.yusp.commons.log.dbpool.collect.LocalLogDbPoolMetricsEndpoint;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.util.CollectionUtils;

public class DbPoolTimedCollector
implements TimedCollector {
    private static final Logger log = LoggerFactory.getLogger(DbPoolTimedCollector.class);
    private final String cron;
    private final LocalLogDbPoolMetricsEndpoint endpoint;

    public DbPoolTimedCollector(String cron, LocalLogDbPoolMetricsEndpoint endpoint) {
        this.cron = cron;
        this.endpoint = endpoint;
    }

    public Trigger getTrigger() {
        return new CronTrigger(this.cron);
    }

    public void run() {
        try {
            log.debug("db pool begin collect!");
            Map<String, Object> map = this.endpoint.getDbPoolEntityByDbParams();
            if (!CollectionUtils.isEmpty(map)) {
                map.put("timestamp", System.currentTimeMillis());
                DbPoolLogger.info(map);
            }
        }
        catch (Exception e) {
            log.error("collect db pool info failure.", (Throwable)e);
        }
    }
}

