/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.log.dbpool.collect;

import cn.com.yusys.yusp.commons.log.dbpool.constant.DbPoolConstant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.metrics.MetricsEndpoint;

public class LocalLogDbPoolMetricsEndpoint {
    private final Logger log = LoggerFactory.getLogger(LocalLogDbPoolMetricsEndpoint.class);
    private final MetricsEndpoint metricsEndpoint;

    public LocalLogDbPoolMetricsEndpoint(MetricsEndpoint metricsEndpoint) {
        this.metricsEndpoint = metricsEndpoint;
    }

    public Map<String, Object> getDbPoolEntityByDbParams() {
        List list = DbPoolConstant.getEnumList(DbPoolConstant.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (DbPoolConstant dbPoolConstant : list) {
            String dbPoolName = dbPoolConstant.getName();
            try {
                MetricsEndpoint.MetricResponse metricResponse = this.metricsEndpoint.metric(dbPoolName, null);
                if (metricResponse == null) continue;
                map.put(dbPoolConstant.getCname(), metricResponse);
            }
            catch (Exception e) {
                this.log.error("db pool collect exception", (Throwable)e);
            }
        }
        return map;
    }
}

