/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.log.common.kafka.strategy;

import cn.com.yusys.yusp.commons.log.common.kafka.strategy.DeliveryStrategy;
import cn.com.yusys.yusp.commons.log.common.kafka.strategy.FailedDeliveryCallback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.TimeoutException;

public class AsynchronousDeliveryStrategy
implements DeliveryStrategy {
    @Override
    public <K, V, E> boolean send(Producer<K, V> producer, ProducerRecord<K, V> record, E event, FailedDeliveryCallback<E> failedDeliveryCallback) {
        try {
            producer.send(record, (metadata, exception) -> {
                if (exception != null) {
                    failedDeliveryCallback.onFailedDelivery(event, exception);
                }
            });
            return true;
        }
        catch (TimeoutException e) {
            failedDeliveryCallback.onFailedDelivery(event, e);
            return false;
        }
    }
}

