/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.log.common.ip;

import cn.com.yusys.yusp.commons.log.common.appender.JsonAppender;
import cn.com.yusys.yusp.commons.log.common.ip.CustomizedApplicationIP;
import cn.com.yusys.yusp.commons.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;

public class IpListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(IpListener.class);
    private static final String LOCAL_IP = "127.0.0.1";
    private static final String SPRING_CLOUD_IP_ADDRESS = "spring.cloud.client.ip-address";
    private static final String EUREKA_PARAM = "eureka.instance.ip-address";
    private static final String CONSUL_IP_ADDRESS = "spring.cloud.consul.discovery.ip-address";
    private static final String NACOS_IP_ADDRESS = "spring.cloud.nacos.discovery.server-addr";

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        String springCloudIp = event.getEnvironment().getProperty(SPRING_CLOUD_IP_ADDRESS);
        if (this.checkIp(springCloudIp)) {
            this.update2EnvironmentIp(springCloudIp);
            return;
        }
        String eurekaIp = event.getEnvironment().getProperty(EUREKA_PARAM);
        if (this.checkIp(eurekaIp)) {
            this.update2EnvironmentIp(eurekaIp);
        }
    }

    private void update2EnvironmentIp(String ip) {
        logger.info("Use environment ip address:{}", (Object)ip);
        CustomizedApplicationIP.updateIp(ip);
        JsonAppender.updateIp(ip);
    }

    private boolean checkIp(String ip) {
        return StringUtils.nonEmpty((CharSequence)ip) && !StringUtils.equalsIgnoreCase((CharSequence)ip, (CharSequence)LOCAL_IP);
    }

    public int getOrder() {
        return -2147483638;
    }
}

