/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.log.api;

import cn.com.yusys.yusp.commons.log.ApiData;
import cn.com.yusys.yusp.commons.log.ApiReporter;
import cn.com.yusys.yusp.commons.log.api.ApiLogData;
import cn.com.yusys.yusp.commons.log.api.ApiLogger;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public class LogApiReporter
implements ApiReporter {
    private static final Logger log = LoggerFactory.getLogger(LogApiReporter.class);
    private static final int STATUS_OK = 200;
    private static final int STATUS_ERROR = 500;
    List<String> ignoreUrls = Collections.singletonList("/favicon.ico");
    private final AntPathMatcher matcher = new AntPathMatcher();

    public void report(ApiData data) {
        if (this.skipApiDataReport(data)) {
            log.debug("ignore :{} collect api data.", (Object)data.getPath());
            return;
        }
        ApiLogData logData = this.convert(data);
        try {
            ApiLogger.info(logData);
        }
        catch (JsonProcessingException e) {
            log.debug("Output Api Data failed, cause by:{} ", (Object)e.getMessage());
        }
    }

    boolean skipApiDataReport(ApiData apiData) {
        return this.ignoreUrls.stream().anyMatch(ignorePattern -> this.matcher.match(ignorePattern, apiData.getPath()));
    }

    private ApiLogData convert(ApiData data) {
        ApiLogData logData = new ApiLogData();
        logData.setTransactionId(StringUtils.getUUID());
        logData.setContentLength(data.getContentLength());
        logData.setUrlFull(data.getFullPath());
        logData.setUrlPath(data.getPath());
        boolean status = data.isStatus();
        if (!status) {
            logData.setErrorId(StringUtils.getUUID());
        }
        logData.setMethod(data.getMethod());
        logData.setLogTimestamp(data.getEndTime());
        logData.setStatus(status ? 200 : 500);
        logData.setTimeTaken(data.getEndTime() - data.getBeginTime());
        return logData;
    }
}

