/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.log.api.collect;

import cn.com.yusys.yusp.commons.log.api.ApiLogger;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.trace.http.HttpTrace;
import org.springframework.boot.actuate.trace.http.InMemoryHttpTraceRepository;
import org.springframework.util.AntPathMatcher;

public class CustomInMemoryHttpTraceRepository
extends InMemoryHttpTraceRepository {
    private static final int HTTP_STATUS_OK = 200;
    private static final Logger log = LoggerFactory.getLogger(CustomInMemoryHttpTraceRepository.class);
    private final AntPathMatcher matcher = new AntPathMatcher();

    public void add(HttpTrace trace) {
        super.add(trace);
        if (trace.getResponse() == null) {
            return;
        }
        String urlPath = trace.getRequest().getUri().getPath();
        List<String> ignoreUrls = Collections.singletonList("/favicon.ico");
        boolean flag = false;
        for (String urlPattern : ignoreUrls) {
            if (!this.matcher.match(urlPattern, urlPath)) continue;
            flag = true;
        }
        if (!flag) {
            try {
                Map<String, Object> messageObject = this.buildMessageInfo(trace);
                messageObject.put("urlPath", urlPath);
                ApiLogger.info(messageObject);
            }
            catch (JsonProcessingException e) {
                log.error("Parse Api message exception:{}", (Object)e.getMessage());
            }
        }
    }

    private Map<String, Object> buildMessageInfo(HttpTrace trace) {
        HashMap<String, Object> messageObject = new HashMap<String, Object>();
        String transactionId = StringUtils.getUUID();
        long timestamp = Date.from(trace.getTimestamp()).getTime();
        int status = trace.getResponse().getStatus();
        messageObject.put("transactionId", transactionId);
        messageObject.put("logTimestamp", timestamp);
        messageObject.put("urlFull", trace.getRequest().getUri().toString());
        messageObject.put("method", trace.getRequest().getMethod());
        messageObject.put("status", status);
        messageObject.put("timeTaken", trace.getTimeTaken());
        messageObject.put("contentLength", trace.getRequest().getHeaders().get("Content-Length") == null ? Double.parseDouble("0") : Double.parseDouble((String)((List)trace.getRequest().getHeaders().get("Content-Length")).get(0)));
        if (status != 200) {
            messageObject.put("errorId", StringUtils.getUUID());
        }
        return messageObject;
    }
}

