/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.job.core.util;

import java.io.IOException;
import java.net.ServerSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtil {
    private static Logger logger = LoggerFactory.getLogger(NetUtil.class);

    public static int findAvailablePort(int defaultPort) {
        int portTmp;
        for (portTmp = defaultPort; portTmp < 65535; ++portTmp) {
            if (NetUtil.isPortUsed(portTmp)) continue;
            return portTmp;
        }
        for (portTmp = defaultPort--; portTmp > 0; --portTmp) {
            if (NetUtil.isPortUsed(portTmp)) continue;
            return portTmp;
        }
        throw new IllegalStateException("no available port.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortUsed(int port) {
        boolean used = false;
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(port);
            used = false;
        }
        catch (IOException e) {
            logger.debug(">>>>>>>>>>> job, port[{}] is in use.", (Object)port);
            used = true;
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException e) {
                    logger.info("");
                }
            }
        }
        return used;
    }
}

