/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.job.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);

    public static boolean deleteRecursively(File root) {
        if (root != null && root.exists()) {
            File[] children;
            if (root.isDirectory() && (children = root.listFiles()) != null) {
                for (File child : children) {
                    FileUtil.deleteRecursively(child);
                }
            }
            return root.delete();
        }
        return false;
    }

    public static void writeFileContent(File file, byte[] data) {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(data);
            fos.flush();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static byte[] readFileContent(File file) {
        long filelength = file.length();
        byte[] filecontent = new byte[(int)filelength];
        try (FileInputStream in = new FileInputStream(file);){
            int count = in.read(filecontent);
            logger.debug("file[{}] has read byte length is:{}", (Object)file.getName(), (Object)count);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return filecontent;
    }
}

