/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.job.core.rpc.netcom.jetty.server;

import cn.com.yusys.yusp.commons.job.core.biz.model.ReturnT;
import cn.com.yusys.yusp.commons.job.core.rpc.codec.RpcRequest;
import cn.com.yusys.yusp.commons.job.core.rpc.codec.RpcResponse;
import cn.com.yusys.yusp.commons.job.core.rpc.netcom.NetComServerFactory;
import cn.com.yusys.yusp.commons.job.core.rpc.serialize.HessianSerializer;
import cn.com.yusys.yusp.commons.job.core.util.HttpClientUtil;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class JettyServerHandler
extends AbstractHandler {
    private static Logger logger = LoggerFactory.getLogger(JettyServerHandler.class);
    private boolean verifyAccessToken = false;
    private String accessToken;

    public JettyServerHandler() {
    }

    public JettyServerHandler(boolean verifyAccessToken, String accessToken) {
        this.verifyAccessToken = verifyAccessToken;
        if (verifyAccessToken) {
            Assert.hasText((String)accessToken, (String)" Static token must be configured!");
        }
        this.accessToken = this.convertAccessToken(accessToken);
    }

    private String convertAccessToken(String accessToken) {
        return "Bearer" + " " + accessToken;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RpcResponse rpcResponse = this.doInvoke(request);
        byte[] responseBytes = HessianSerializer.serialize(rpcResponse);
        response.setContentType("text/html;charset=utf-8");
        response.setStatus(200);
        baseRequest.setHandled(true);
        ServletOutputStream out = response.getOutputStream();
        out.write(responseBytes);
        out.flush();
    }

    private RpcResponse doInvoke(HttpServletRequest request) {
        try {
            String authorization;
            byte[] requestBytes = HttpClientUtil.readBytes(request);
            if (requestBytes == null || requestBytes.length == 0) {
                RpcResponse rpcResponse = new RpcResponse();
                rpcResponse.setError("RpcRequest byte[] is null");
                return rpcResponse;
            }
            RpcRequest rpcRequest = (RpcRequest)HessianSerializer.deserialize(requestBytes, RpcRequest.class);
            if (this.verifyAccessToken && !Objects.equals(this.accessToken, authorization = request.getHeader("JobToken"))) {
                logger.warn(" Token verification failed, request access token is:{}", (Object)authorization);
                return RpcResponse.create(null, new ReturnT("999999", "Access token verification failed"));
            }
            RpcResponse rpcResponse = NetComServerFactory.invokeService(rpcRequest, null);
            return rpcResponse;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            RpcResponse rpcResponse = new RpcResponse();
            rpcResponse.setError("Server-error:" + e.getMessage());
            return rpcResponse;
        }
    }
}

