/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.job.core.rpc.netcom;

import cn.com.yusys.yusp.commons.job.core.rpc.codec.RpcRequest;
import cn.com.yusys.yusp.commons.job.core.rpc.codec.RpcResponse;
import cn.com.yusys.yusp.commons.job.core.rpc.netcom.jetty.client.JettyClient;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.style.StylerUtils;

public class NetComClientProxy
implements FactoryBean<Object> {
    private static final Logger logger = LoggerFactory.getLogger(NetComClientProxy.class);
    private Class<?> iface;
    private String serverAddress;
    private String accessToken;
    private boolean jsonFlag;
    private JettyClient client = new JettyClient();

    public NetComClientProxy(Class<?> iface, String serverAddress, String accessToken, boolean jsonFlag) {
        this.iface = iface;
        this.serverAddress = serverAddress;
        this.accessToken = accessToken;
        this.jsonFlag = jsonFlag;
    }

    public Object getObject() {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{this.iface}, (proxy, method, args) -> {
            if (method.getDeclaringClass().isAssignableFrom(Object.class)) {
                logger.error(">>>>>>>>>>> xxl-rpc proxy class-method not support [{}.{}]", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
                throw new RuntimeException("xxl-rpc proxy class-method not support");
            }
            if ("toString".equals(method.getName())) {
                return this.toString();
            }
            RpcRequest request = new RpcRequest();
            request.setServerAddress(this.serverAddress);
            request.setCreateMillisTime(String.valueOf(System.currentTimeMillis()));
            request.setAccessToken(this.accessToken);
            request.setClassName(method.getDeclaringClass().getName());
            request.setMethodName(method.getName());
            request.setParameterTypes(method.getParameterTypes());
            request.setParameters(args);
            logger.info("access Token is:{}", (Object)this.accessToken);
            logger.debug("Clientbegin===================================================================");
            logger.debug(" send begin, request:{}", (Object)request);
            RpcResponse response = this.jsonFlag ? this.client.sendJson(request) : this.client.send(request);
            logger.debug("send end, response:{}", (Object)response);
            logger.debug("Client end===================================================================");
            if (response == null) {
                logger.error(">>>>>>>>>>> xxl-rpc netty response not found.");
                throw new Exception(">>>>>>>>>>> xxl-rpc netty response not found.");
            }
            if (response.isError()) {
                logger.error(StylerUtils.style((Object)response));
                throw new RuntimeException(response.getError());
            }
            return response.getResult();
        });
    }

    public Class<?> getObjectType() {
        return this.iface;
    }

    public boolean isSingleton() {
        return false;
    }
}

