/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.job.core.util;

import java.io.IOException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String DEFAULT_CONTENT_TYPE = "application/json;UTF-8";
    public static final String BODY_SERIALIZER_KEY = "bodySerializer";
    public static final String BEARER = "Bearer";
    public static final String AUTHORIZATION = "JobToken";

    public static byte[] postRequest(String reqURL, byte[] date, String accessToken) throws Exception {
        byte[] responseBytes = null;
        HttpPost httpPost = new HttpPost(reqURL);
        httpPost.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        logger.info("access Token is:{}", (Object)accessToken);
        if (null != accessToken) {
            httpPost.addHeader(AUTHORIZATION, "Bearer " + accessToken);
        }
        CloseableHttpClient httpClient = HttpClients.custom().disableAutomaticRetries().build();
        try {
            CloseableHttpResponse response;
            HttpEntity entity;
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(10000).setSocketTimeout(10000).setConnectTimeout(10000).build();
            httpPost.setConfig(requestConfig);
            if (date != null) {
                httpPost.setEntity((HttpEntity)new ByteArrayEntity(date, ContentType.DEFAULT_BINARY));
            }
            if (null != (entity = (response = httpClient.execute((HttpUriRequest)httpPost)).getEntity())) {
                responseBytes = EntityUtils.toByteArray((HttpEntity)entity);
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            httpPost.releaseConnection();
            try {
                httpClient.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return responseBytes;
    }

    public static final byte[] readBytes(HttpServletRequest request) throws IOException {
        request.setCharacterEncoding(DEFAULT_CHARSET);
        int contentLen = request.getContentLength();
        ServletInputStream is = request.getInputStream();
        if (contentLen > 0) {
            byte[] message = new byte[contentLen];
            try {
                int readLengthThisTime;
                for (int readLen = 0; readLen != contentLen && (readLengthThisTime = is.read(message, readLen, contentLen - readLen)) != -1; readLen += readLengthThisTime) {
                }
                return message;
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        return new byte[0];
    }
}

