/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.job.core.rpc.netcom.jetty.client;

import cn.com.yusys.yusp.commons.job.core.rpc.codec.RpcRequest;
import cn.com.yusys.yusp.commons.job.core.rpc.codec.RpcResponse;
import cn.com.yusys.yusp.commons.job.core.rpc.serialize.HessianSerializer;
import cn.com.yusys.yusp.commons.job.core.util.HttpClientUtil;
import cn.com.yusys.yusp.commons.job.core.util.JacksonUtil;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyClient {
    private static Logger logger = LoggerFactory.getLogger(JettyClient.class);

    public RpcResponse sendJson(RpcRequest request) {
        try {
            byte[] responseBytes;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("bodySerializer", new String(HessianSerializer.serialize(request)));
            String jsonString = JacksonUtil.writeValueAsString(map);
            byte[] requestBytes = jsonString.getBytes("UTF-8");
            String reqURL = request.getServerAddress();
            if (reqURL != null && reqURL.toLowerCase().indexOf("http") == -1) {
                reqURL = "http://" + request.getServerAddress() + "/";
            }
            if ((responseBytes = HttpClientUtil.postRequest(reqURL, requestBytes, request.getAccessToken())) == null || responseBytes.length == 0) {
                RpcResponse rpcResponse = new RpcResponse();
                rpcResponse.setError("RpcResponse byte[] is null");
                return rpcResponse;
            }
            RpcResponse rpcResponse = (RpcResponse)HessianSerializer.deserialize(responseBytes, RpcResponse.class);
            return rpcResponse;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            RpcResponse rpcResponse = new RpcResponse();
            rpcResponse.setError("Client-error:" + e.getMessage());
            return rpcResponse;
        }
    }

    public RpcResponse send(RpcRequest request) {
        try {
            byte[] responseBytes;
            byte[] requestBytes = HessianSerializer.serialize(request);
            String reqURL = request.getServerAddress();
            if (reqURL != null && reqURL.toLowerCase().indexOf("http") == -1) {
                reqURL = "http://" + request.getServerAddress() + "/";
            }
            if ((responseBytes = HttpClientUtil.postRequest(reqURL, requestBytes, request.getAccessToken())) == null || responseBytes.length == 0) {
                RpcResponse rpcResponse = new RpcResponse();
                rpcResponse.setError("RpcResponse byte[] is null");
                return rpcResponse;
            }
            RpcResponse rpcResponse = (RpcResponse)HessianSerializer.deserialize(responseBytes, RpcResponse.class);
            return rpcResponse;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            RpcResponse rpcResponse = new RpcResponse();
            rpcResponse.setError("Client-error:" + e.getMessage());
            return rpcResponse;
        }
    }

    public RpcResponse sendDefault(RpcRequest request) throws Exception {
        try {
            byte[] responseBytes;
            String jsonString = JacksonUtil.writeValueAsString(request);
            byte[] requestBytes = jsonString.getBytes("UTF-8");
            String reqURL = request.getServerAddress();
            if (reqURL != null && reqURL.toLowerCase().indexOf("http") == -1) {
                reqURL = "http://" + request.getServerAddress() + "/";
            }
            if ((responseBytes = HttpClientUtil.postRequest(reqURL, requestBytes, request.getAccessToken())) == null || responseBytes.length == 0) {
                RpcResponse rpcResponse = new RpcResponse();
                rpcResponse.setError("RpcResponse byte[] is null");
                return rpcResponse;
            }
            RpcResponse rpcResponse = (RpcResponse)HessianSerializer.deserialize(responseBytes, RpcResponse.class);
            return rpcResponse;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            RpcResponse rpcResponse = new RpcResponse();
            rpcResponse.setError("Client-error:" + e.getMessage());
            return rpcResponse;
        }
    }

    public static void main(String[] args) throws JsonParseException, JsonMappingException, IOException {
        RpcRequest request = new RpcRequest();
        Object[] param = new Object[]{new String("xx"), 100, 100L};
        Class[] paramType = new Class[]{String.class, Integer.class, Long.class};
        request.setParameters(param);
        request.setParameterTypes(paramType);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("bodySerializer", new String(HessianSerializer.serialize(request)));
        String jsonString = JacksonUtil.writeValueAsString(map);
        byte[] requestBytes = jsonString.getBytes("UTF-8");
        Map map2 = (Map)JacksonUtil.getInstance().readValue(requestBytes, Map.class);
        byte[] requestBytes2 = ((String)map2.get("bodySerializer")).getBytes("UTF-8");
        RpcRequest rpcRequest2 = (RpcRequest)HessianSerializer.deserialize(requestBytes2, RpcRequest.class);
        System.out.println(rpcRequest2);
    }
}

