/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.job.core.executor;

import cn.com.yusys.yusp.commons.job.core.biz.AdminBiz;
import cn.com.yusys.yusp.commons.job.core.biz.ExecutorBiz;
import cn.com.yusys.yusp.commons.job.core.biz.impl.ExecutorBizImpl;
import cn.com.yusys.yusp.commons.job.core.enums.SideType;
import cn.com.yusys.yusp.commons.job.core.handler.IJobHandler;
import cn.com.yusys.yusp.commons.job.core.handler.annotation.JobHandler;
import cn.com.yusys.yusp.commons.job.core.log.JobFileAppender;
import cn.com.yusys.yusp.commons.job.core.permission.Permission;
import cn.com.yusys.yusp.commons.job.core.rpc.netcom.NetComClientProxy;
import cn.com.yusys.yusp.commons.job.core.rpc.netcom.NetComServerFactory;
import cn.com.yusys.yusp.commons.job.core.rpc.serialize.HessianSerializer;
import cn.com.yusys.yusp.commons.job.core.thread.JobLogFileCleanThread;
import cn.com.yusys.yusp.commons.job.core.thread.JobThread;
import cn.com.yusys.yusp.commons.job.core.util.NetUtil;
import cn.com.yusys.yusp.commons.job.core.util.SpringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlJobExecutor {
    private static final Logger logger = LoggerFactory.getLogger(XxlJobExecutor.class);
    private String adminAddresses;
    private String appName;
    private String ip;
    private int port;
    private String logPath;
    private int logRetentionDays;
    private Permission permission;
    private static List<AdminBiz> adminBizList;
    private NetComServerFactory serverFactory = new NetComServerFactory();
    private static ConcurrentHashMap<String, IJobHandler> jobHandlerRepository;
    private static ConcurrentHashMap<String, JobThread> JobThreadRepository;
    private static HessianSerializer serializer;

    public void setAdminAddresses(String adminAddresses) {
        this.adminAddresses = adminAddresses;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPermission(Permission permission) {
        this.permission = permission;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public void setLogRetentionDays(int logRetentionDays) {
        this.logRetentionDays = logRetentionDays;
    }

    public void start() throws Exception {
        String accessToken = null;
        if (SideType.CLIENT.equals((Object)this.permission.getSideType()) && this.permission.isServerVerify()) {
            accessToken = this.permission.getAccessToken();
        }
        XxlJobExecutor.initAdminBizList(this.adminAddresses, accessToken);
        XxlJobExecutor.initJobHandlerRepository();
        JobFileAppender.initLogPath(this.logPath);
        if (SideType.CLIENT.equals((Object)this.permission.getSideType())) {
            this.initExecutorServer(this.port, this.ip, this.appName, this.permission.isClientVerify(), this.permission.getAccessToken());
        } else {
            this.initExecutorServer(this.port, this.ip, this.appName, false, null);
        }
        JobLogFileCleanThread.getInstance().start(this.logRetentionDays);
    }

    public void destroy() {
        if (JobThreadRepository.size() > 0) {
            for (Map.Entry<String, JobThread> item : JobThreadRepository.entrySet()) {
                XxlJobExecutor.removeJobThread(item.getKey(), "Web\u5bb9\u5668\u9500\u6bc1\u7ec8\u6b62");
            }
            JobThreadRepository.clear();
        }
        this.stopExecutorServer();
        JobLogFileCleanThread.getInstance().toStop();
    }

    private static void initAdminBizList(String adminAddresses, String accessToken) {
        if (adminAddresses != null && adminAddresses.trim().length() > 0) {
            for (String address : adminAddresses.trim().split(",")) {
                if (address == null || address.trim().length() <= 0) continue;
                String addressUrl = address.concat("/api/server");
                AdminBiz adminBiz = (AdminBiz)new NetComClientProxy(AdminBiz.class, addressUrl, accessToken, true).getObject();
                if (adminBizList == null) {
                    adminBizList = new ArrayList<AdminBiz>();
                }
                adminBizList.add(adminBiz);
            }
        }
    }

    public static List<AdminBiz> getAdminBizList() {
        return adminBizList;
    }

    private void initExecutorServer(int port, String ip, String appName, boolean verifyAccessToken, String accessToken) throws Exception {
        port = port > 0 ? port : NetUtil.findAvailablePort(9999);
        NetComServerFactory.putService(ExecutorBiz.class, new ExecutorBizImpl());
        this.serverFactory.start(port, ip, appName, verifyAccessToken, accessToken);
    }

    private void stopExecutorServer() {
        this.serverFactory.destroy();
    }

    public static IJobHandler registerJobHandler(String name, IJobHandler jobHandler) {
        logger.info(">>>>>>>>>>> job register job handler success, name:{}, jobHandler:{}", (Object)name, (Object)jobHandler);
        return jobHandlerRepository.put(name, jobHandler);
    }

    public static IJobHandler loadJobHandler(String name) {
        return jobHandlerRepository.get(name);
    }

    private static void initJobHandlerRepository() {
        Map<String, Object> serviceBeanMap = SpringUtil.getBeansWithAnnotation(JobHandler.class);
        if (serviceBeanMap != null && serviceBeanMap.size() > 0) {
            for (Object serviceBean : serviceBeanMap.values()) {
                if (!(serviceBean instanceof IJobHandler)) continue;
                String name = serviceBean.getClass().getAnnotation(JobHandler.class).value();
                IJobHandler handler = (IJobHandler)serviceBean;
                if (XxlJobExecutor.loadJobHandler(name) != null) {
                    throw new RuntimeException("job job handler naming conflicts.");
                }
                XxlJobExecutor.registerJobHandler(name, handler);
            }
        }
    }

    public static JobThread registJobThread(String jobId, IJobHandler handler, String removeOldReason) {
        JobThread newJobThread = new JobThread(jobId, handler);
        newJobThread.start();
        logger.info(">>>>>>>>>>> job regist JobThread success, jobId:{}, handler:{}", new Object[]{jobId, handler});
        JobThread oldJobThread = JobThreadRepository.put(jobId, newJobThread);
        if (oldJobThread != null) {
            oldJobThread.toStop(removeOldReason);
            oldJobThread.interrupt();
        }
        return newJobThread;
    }

    public static void removeJobThread(String jobId, String removeOldReason) {
        JobThread oldJobThread = JobThreadRepository.remove(jobId);
        if (oldJobThread != null) {
            oldJobThread.toStop(removeOldReason);
            oldJobThread.interrupt();
        }
    }

    public static JobThread loadJobThread(String jobId) {
        JobThread jobThread = JobThreadRepository.get(jobId);
        return jobThread;
    }

    public static HessianSerializer getSerializer() {
        return serializer;
    }

    static {
        jobHandlerRepository = new ConcurrentHashMap();
        JobThreadRepository = new ConcurrentHashMap();
        serializer = new HessianSerializer();
    }
}

