/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.idempotent.support;

import cn.com.yusys.yusp.commons.idempotent.IdempotentStore;
import cn.com.yusys.yusp.commons.util.DataSourceUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcTemplate;

public class DatabaseIdempotentStore
implements IdempotentStore,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseIdempotentStore.class);
    private static final String CREATE_SCRIPT_PREFIX = "IdempotentCreate_";
    private final JdbcTemplate jdbcTemplate;
    private final String tableName;
    private final boolean enabledInit;

    public DatabaseIdempotentStore(JdbcTemplate jdbcTemplate, String tableName, boolean enabledInit) {
        this.jdbcTemplate = jdbcTemplate;
        this.tableName = tableName;
        this.enabledInit = enabledInit;
    }

    @Override
    public boolean write(String key) {
        String writeSql = StringUtils.builder0((Object[])new Object[]{"insert into ", this.tableName, "(IDEMPOTENT_ID, EXECUTE_TIME) VALUES ('", key, "', '", DateUtils.formatDate((String)DateUtils.PATTERN_DATETIME_COMPACT_SSS), "')"});
        try {
            return DataSourceUtils.executeUpdateScript((DataSource)this.jdbcTemplate.getDataSource(), (String)writeSql);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public void afterNotify(String key) {
    }

    @Override
    public void exception(String key) {
    }

    public void afterPropertiesSet() throws Exception {
        if (this.enabledInit) {
            DataSourceUtils.createTable((String)CREATE_SCRIPT_PREFIX, (String)this.tableName);
        }
    }
}

