/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.idempotent;

import cn.com.yusys.yusp.commons.idempotent.IdempotentStore;
import cn.com.yusys.yusp.commons.idempotent.VoidSupplier;
import cn.com.yusys.yusp.commons.idempotent.exception.IdempotentException;
import cn.com.yusys.yusp.commons.idempotent.exception.IdempotentRefuseException;
import cn.com.yusys.yusp.commons.util.Asserts;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdempotentUtils {
    private static final Logger logger = LoggerFactory.getLogger(IdempotentUtils.class);
    private static IdempotentStore store;
    private static final AtomicBoolean ENABLED_INIT;

    private IdempotentUtils() {
    }

    public static void setGlobalParams(IdempotentStore store) {
        if (ENABLED_INIT.compareAndSet(false, true)) {
            IdempotentUtils.store = store;
        }
    }

    public static <T> T execute(String idempotentId, Supplier<T> supplier) {
        Asserts.nonEmpty((CharSequence)idempotentId, (Object[])new Object[]{"Idempotent id must not null or empty!"});
        try {
            boolean writeResult = store.write(idempotentId);
            logger.info("Idempotent global id [{}] write result is:{}", (Object)idempotentId, (Object)writeResult);
            if (writeResult) {
                logger.debug("Idempotent global id [{}] write success, start execute biz logic!", (Object)idempotentId);
                T executeResult = null;
                try {
                    executeResult = supplier.get();
                    store.afterNotify(idempotentId);
                }
                catch (IdempotentException e) {
                    logger.error("Idempotent global id [{}], biz logic execute fail! cause by:{}", (Object)idempotentId, (Object)e.getMessage());
                    throw e;
                }
                logger.debug("Idempotent global id [{}], biz logic execute success!", (Object)idempotentId);
                return executeResult;
            }
            throw new IdempotentRefuseException("Current business logic executed!");
        }
        catch (IdempotentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            store.exception(idempotentId);
            throw e;
        }
    }

    public static void execute(String idempotentId, VoidSupplier voidSupplier) {
        Asserts.nonEmpty((CharSequence)idempotentId, (Object[])new Object[]{"Idempotent id must not null or empty!"});
        try {
            boolean writeResult = store.write(idempotentId);
            logger.info("Idempotent global id [{}] write result is:{}", (Object)idempotentId, (Object)writeResult);
            if (writeResult) {
                logger.debug("Idempotent global id [{}] write success, start execute biz logic!", (Object)idempotentId);
                try {
                    voidSupplier.execute();
                    store.afterNotify(idempotentId);
                }
                catch (IdempotentException e) {
                    logger.error("Idempotent global id [{}], biz logic execute fail! cause by:{}", (Object)idempotentId, (Object)e.getMessage());
                    throw e;
                }
            } else {
                throw new IdempotentRefuseException("Current business logic executed!");
            }
            logger.debug("Idempotent global id [{}], biz logic execute success!", (Object)idempotentId);
        }
        catch (IdempotentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            store.exception(idempotentId);
            throw e;
        }
    }

    static {
        ENABLED_INIT = new AtomicBoolean(false);
    }
}

