/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.idempotent.support;

import cn.com.yusys.yusp.commons.idempotent.IdempotentStore;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisIdempotentStore
implements IdempotentStore {
    private final StringRedisTemplate redisTemplate;
    private final String idempotentCacheName;
    private final long expire;
    public static final String IDEMPOTENT_GROUP_SEPARATOR = ":";

    public RedisIdempotentStore(StringRedisTemplate redisTemplate, String cacheName, long expire) {
        this.redisTemplate = redisTemplate;
        this.idempotentCacheName = cacheName;
        this.expire = expire;
    }

    @Override
    public boolean write(String key) {
        String redisKey = StringUtils.builder0((Object[])new Object[]{this.idempotentCacheName, IDEMPOTENT_GROUP_SEPARATOR, key});
        Boolean result = this.redisTemplate.opsForValue().setIfAbsent((Object)redisKey, (Object)DateUtils.formatDate((String)DateUtils.PATTERN_DATETIME_COMPACT_SSS));
        return result != null && result != false;
    }

    @Override
    public void afterNotify(String key) {
        String redisKey = StringUtils.builder0((Object[])new Object[]{this.idempotentCacheName, IDEMPOTENT_GROUP_SEPARATOR, key});
        this.redisTemplate.opsForValue().append((Object)redisKey, StringUtils.builder0((Object[])new Object[]{"-", DateUtils.formatDate((String)DateUtils.PATTERN_DATETIME_COMPACT_SSS)}));
        this.redisTemplate.expire((Object)redisKey, this.expire, TimeUnit.SECONDS);
    }

    @Override
    public void exception(String key) {
    }
}

