/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.util;

import cn.com.yusys.yusp.commons.file.AbstractUploadStream;
import cn.com.yusys.yusp.commons.file.template.FileSystemTemplate;
import cn.com.yusys.yusp.commons.file.util.FileInfoUtils;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.io.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FileUtils {
    public static byte[] readTemporaryFileToByte(String fileId) throws IOException {
        try (InputStream is = FileInfoUtils.temporaryFileSystemTemplate().openDownloadStream(FileInfoUtils.fromIdentity(fileId));){
            byte[] byArray = IOUtils.readBytes((InputStream)is, (boolean)false);
            return byArray;
        }
    }

    public static byte[] readToByte(String fileId) throws IOException {
        return FileUtils.readToByte(FileUtils.getUniqueFileSystemTemplate(), fileId);
    }

    public static byte[] readToByte(String fileSystemTemplateName, String fileId) throws IOException {
        return FileUtils.readToByte((FileSystemTemplate)SpringContextUtils.getBean((String)fileSystemTemplateName, FileSystemTemplate.class), fileId);
    }

    public static byte[] readToByte(FileSystemTemplate fileSystemTemplate, String fileId) throws IOException {
        try (InputStream is = fileSystemTemplate.openDownloadStream(FileInfoUtils.fromIdentity(fileId));){
            byte[] byArray = IOUtils.readBytes((InputStream)is, (boolean)false);
            return byArray;
        }
    }

    public static InputStream openTemporaryFileInputStream(String fileId) {
        return FileInfoUtils.temporaryFileSystemTemplate().openDownloadStream(FileInfoUtils.fromIdentity(fileId));
    }

    public static InputStream openInputStream(String fileId) {
        return FileUtils.openInputStream(FileUtils.getUniqueFileSystemTemplate(), fileId);
    }

    public static InputStream openInputStream(String fileSystemTemplateName, String fileId) {
        return FileUtils.openInputStream((FileSystemTemplate)SpringContextUtils.getBean((String)fileSystemTemplateName, FileSystemTemplate.class), fileId);
    }

    private static InputStream openInputStream(FileSystemTemplate fileSystemTemplate, String fileId) {
        return fileSystemTemplate.openDownloadStream(FileInfoUtils.fromIdentity(fileId));
    }

    public static String uploadTemporaryFile(File file) {
        return FileInfoUtils.toIdentity(FileInfoUtils.uploadTempFile(file));
    }

    public static String uploadTemporaryFile(byte[] bytes, String fileName) throws IOException {
        return FileUtils.uploadTemporaryFile(bytes, bytes.length, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadTemporaryFile(byte[] bytes, long size, String fileName) throws IOException {
        AbstractUploadStream os = null;
        try {
            os = FileInfoUtils.temporaryFileSystemTemplate().openUploadStream(fileName, FileInfoUtils.getTempFilePath(), size);
            os.write(bytes);
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{os});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{os});
        return FileInfoUtils.toIdentity(os.getUploadedFile());
    }

    public static String upload(File file) throws IOException {
        return FileUtils.upload(file, null);
    }

    public static String upload(File file, String remoteFileName) throws IOException {
        return FileUtils.upload(file, remoteFileName, null);
    }

    public static String upload(File file, String remoteFileName, String remotePath) throws IOException {
        return FileUtils.upload(FileUtils.getUniqueFileSystemTemplate(), file.getName(), file.getParent(), remoteFileName, remotePath);
    }

    public static String upload(String fileSystemTemplateName, File file) throws IOException {
        return FileUtils.upload(fileSystemTemplateName, file, null);
    }

    public static String upload(String fileSystemTemplateName, File file, String remoteFileName) throws IOException {
        return FileUtils.upload(fileSystemTemplateName, file, remoteFileName, null);
    }

    public static String upload(String fileSystemTemplateName, File file, String remoteFileName, String remotePath) throws IOException {
        return FileUtils.upload((FileSystemTemplate)SpringContextUtils.getBean((String)fileSystemTemplateName, FileSystemTemplate.class), file.getName(), file.getParent(), remoteFileName, remotePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String upload(FileSystemTemplate fileSystemTemplate, String fileName, String filePath, String remoteFileName, String remoteFilePath) throws IOException {
        AbstractUploadStream os = null;
        try {
            File localFile = new File(StringUtils.builder0((Object[])new Object[]{filePath, File.separator, fileName}));
            try (FileInputStream fis = new FileInputStream(localFile);){
                os = fileSystemTemplate.openUploadStream(StringUtils.isEmpty((CharSequence)remoteFileName) ? fileName : remoteFileName, remoteFilePath, fis.available());
                IOUtils.copy((InputStream)fis, (OutputStream)os);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{os});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{os});
        return FileInfoUtils.toIdentity(os.getUploadedFile());
    }

    public static String upload(byte[] bytes, String fileName) throws IOException {
        return FileUtils.upload(bytes, bytes.length, fileName);
    }

    public static String upload(byte[] bytes, String path, String fileName) throws IOException {
        return FileUtils.upload(bytes, bytes.length, path, fileName);
    }

    public static String upload(byte[] bytes, long size, String fileName) throws IOException {
        return FileUtils.upload(bytes, size, null, fileName);
    }

    public static String upload(byte[] bytes, long size, String path, String fileName) throws IOException {
        return FileUtils.upload(FileUtils.getUniqueFileSystemTemplate(), bytes, size, path, fileName);
    }

    public static String upload(String fileSystemTemplateName, byte[] bytes, String fileName) throws IOException {
        return FileUtils.upload(fileSystemTemplateName, bytes, bytes.length, fileName);
    }

    public static String upload(String fileSystemTemplateName, byte[] bytes, String path, String fileName) throws IOException {
        return FileUtils.upload(fileSystemTemplateName, bytes, (long)bytes.length, path, fileName);
    }

    public static String upload(String fileSystemTemplateName, byte[] bytes, long size, String fileName) throws IOException {
        return FileUtils.upload(fileSystemTemplateName, bytes, size, null, fileName);
    }

    public static String upload(String fileSystemTemplateName, byte[] bytes, long size, String path, String fileName) throws IOException {
        return FileUtils.upload((FileSystemTemplate)SpringContextUtils.getBean((String)fileSystemTemplateName, FileSystemTemplate.class), bytes, size, path, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String upload(FileSystemTemplate fileSystemTemplate, byte[] bytes, long size, String path, String fileName) throws IOException {
        AbstractUploadStream os = null;
        try {
            os = fileSystemTemplate.openUploadStream(fileName, path, size);
            os.write(bytes);
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{os});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{os});
        return FileInfoUtils.toIdentity(os.getUploadedFile());
    }

    public static String downloadTemporaryFile(String fileId) throws IOException {
        File tempFile = FileInfoUtils.createTempFile(FileInfoUtils.fromIdentity(fileId).getFileName());
        try (FileOutputStream fos = new FileOutputStream(tempFile);
             InputStream is = FileUtils.openTemporaryFileInputStream(fileId);){
            IOUtils.copy((InputStream)is, (OutputStream)fos);
        }
        return tempFile.getAbsolutePath();
    }

    public static String download(String fileId) throws IOException {
        return FileUtils.download(FileUtils.getUniqueFileSystemTemplate(), fileId);
    }

    public static String download(String fileSystemTemplateName, String fileId) throws IOException {
        return FileUtils.download((FileSystemTemplate)SpringContextUtils.getBean((String)fileSystemTemplateName, FileSystemTemplate.class), fileId);
    }

    private static String download(FileSystemTemplate fileSystemTemplate, String fileId) throws IOException {
        File tempFile = FileInfoUtils.createTempFile(FileInfoUtils.fromIdentity(fileId).getFileName());
        try (FileOutputStream fos = new FileOutputStream(tempFile);
             InputStream is = FileUtils.openInputStream(fileSystemTemplate, fileId);){
            IOUtils.copy((InputStream)is, (OutputStream)fos);
        }
        return tempFile.getAbsolutePath();
    }

    public static boolean deleteTemporaryFile(String fileId) {
        return FileInfoUtils.temporaryFileSystemTemplate().deleteFile(FileInfoUtils.fromIdentity(fileId));
    }

    public static boolean delete(String fileId) {
        return FileUtils.delete(FileUtils.getUniqueFileSystemTemplate(), fileId);
    }

    public static boolean delete(String fileSystemTemplateName, String fileId) {
        return FileUtils.delete((FileSystemTemplate)SpringContextUtils.getBean((String)fileSystemTemplateName, FileSystemTemplate.class), fileId);
    }

    private static boolean delete(FileSystemTemplate fileSystemTemplate, String fileId) {
        return fileSystemTemplate.deleteFile(FileInfoUtils.fromIdentity(fileId));
    }

    private static FileSystemTemplate getUniqueFileSystemTemplate() {
        Map fileSystemTemplateMap = SpringContextUtils.getBeansOfType(FileSystemTemplate.class);
        List fileSystemTemplateList = fileSystemTemplateMap.entrySet().stream().filter(entry -> !"tmpFileTemplate".equals(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        Asserts.isEquals((Object)fileSystemTemplateList.size(), (Object)1, (Object[])new Object[]{"There are multiple FileSystemTemplate bean!"});
        return (FileSystemTemplate)fileSystemTemplateList.get(0);
    }
}

