/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.client;

import cn.com.yusys.yusp.commons.file.AbstractUploadStream;
import cn.com.yusys.yusp.commons.file.FileClientCommand;
import cn.com.yusys.yusp.commons.file.FileInfo;
import cn.com.yusys.yusp.commons.file.FileSystemException;
import cn.com.yusys.yusp.commons.file.client.FileClientPool;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

class PooledFileClientCommand
implements FileClientCommand {
    private FileClientPool pool;
    private FileClientCommand innerCommand;

    public PooledFileClientCommand(FileClientCommand command) {
        this.innerCommand = command;
    }

    public void destroy() throws IOException {
        this.pool = null;
        if (this.innerCommand != null) {
            this.innerCommand.close();
            this.innerCommand = null;
        }
    }

    @Override
    public void close() {
        this.pool.returnObject(this);
    }

    @Override
    public FileInfo upload(String localFileName, String localPath, String remoteFileName, String remotePath) throws FileSystemException {
        return this.innerCommand.upload(localFileName, localPath, remoteFileName, remotePath);
    }

    @Override
    public boolean download(String localFileName, String localPath, String remoteFileName, String remotePath) throws FileSystemException {
        return this.innerCommand.download(localFileName, localPath, remoteFileName, remotePath);
    }

    @Override
    public AbstractUploadStream openUploadStream(String remoteFileName, String remotePath, long size) throws FileSystemException {
        return this.innerCommand.openUploadStream(remoteFileName, remotePath, size);
    }

    @Override
    public InputStream openDownloadStream(String remoteFileName, String remotePath) throws FileSystemException {
        return this.innerCommand.openDownloadStream(remoteFileName, remotePath);
    }

    @Override
    public boolean delete(String remoteFileName, String remotePath) throws FileSystemException {
        return this.innerCommand.delete(remoteFileName, remotePath);
    }

    @Override
    public boolean deleteFolder(String remotePath) throws FileSystemException {
        return this.innerCommand.deleteFolder(remotePath);
    }

    @Override
    public boolean isFileExists(String remoteFileName, String remotePath) {
        return this.innerCommand.isFileExists(remoteFileName, remotePath);
    }

    @Override
    public boolean isFolderExists(String remotePath) {
        return this.innerCommand.isFolderExists(remotePath);
    }

    @Override
    public FileInfo queryFileInfo(String remoteFileName, String remotePath) {
        return this.innerCommand.queryFileInfo(remoteFileName, remotePath);
    }

    @Override
    public List<FileInfo> queryFiles(String remotePath) {
        return this.innerCommand.queryFiles(remotePath);
    }

    @Override
    public List<String> querySubFolder(String remotePath) {
        return this.innerCommand.querySubFolder(remotePath);
    }

    @Override
    public boolean move(String fileName, String originPath, String targetFileName, String targetPath, boolean isOverwrite) throws FileSystemException {
        return this.innerCommand.move(fileName, originPath, targetFileName, targetPath, isOverwrite);
    }

    @Override
    public boolean copy(String fileName, String originPath, String targetFileName, String targetPath, boolean isOverwrite) throws FileSystemException {
        return this.innerCommand.copy(fileName, originPath, targetFileName, targetPath, isOverwrite);
    }

    @Override
    public boolean available() {
        return this.innerCommand.available();
    }

    public FileClientPool getPool() {
        return this.pool;
    }

    public void setPool(FileClientPool pool) {
        this.pool = pool;
    }

    public FileClientCommand getInnerCommand() {
        return this.innerCommand;
    }
}

