/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.client.tencentcos;

import cn.com.yusys.yusp.commons.file.AbstractUploadStream;
import cn.com.yusys.yusp.commons.file.FileClientCommand;
import cn.com.yusys.yusp.commons.file.FileInfo;
import cn.com.yusys.yusp.commons.file.FileSystemException;
import cn.com.yusys.yusp.commons.file.client.AbstractDefaultOutputStream;
import cn.com.yusys.yusp.commons.file.client.tencentcos.ContentType;
import cn.com.yusys.yusp.commons.file.client.tencentcos.CosFileClient;
import cn.com.yusys.yusp.commons.file.util.FilePathUtils;
import cn.com.yusys.yusp.commons.util.IdUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.commons.util.collection.ListUtils;
import cn.com.yusys.yusp.commons.util.io.FileUtils;
import cn.com.yusys.yusp.commons.util.io.IOUtils;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.DeleteObjectRequest;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ListObjectsRequest;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class CosFileClientCommand
implements FileClientCommand {
    private static final Logger logger = LoggerFactory.getLogger(CosFileClientCommand.class);
    private final CosFileClient fileClient;
    private final String bucketName;

    public CosFileClientCommand(CosFileClient fileClient, String bucketName) {
        this.fileClient = fileClient;
        this.bucketName = bucketName;
    }

    public FileInfo upload(String localFileName, String localPath, String remoteFileName, String remotePath) throws FileSystemException {
        String localFile = FilePathUtils.concatFileName((String)localPath, (String)localFileName);
        String remoteFile = FilePathUtils.concatFileName((String)remotePath, (String)remoteFileName);
        PutObjectResult putObjectResult = this.fileClient.client().putObject(CosFileClientCommand.buildPutObjectRequest(this.bucketName, localFile, remoteFile));
        return CosFileClientCommand.buildFileInfo(putObjectResult);
    }

    public boolean download(String localFileName, String localPath, String remoteFileName, String remotePath) throws FileSystemException {
        GetObjectRequest getObjectRequest = CosFileClientCommand.buildGetObjectRequest(this.bucketName, FilePathUtils.concatFileName((String)remotePath, (String)remoteFileName));
        File localFile = this.localFile(localPath, localFileName);
        try (COSObject cosObject = this.fileClient.client().getObject(getObjectRequest);
             FileOutputStream fos = FileUtils.openOutputStream((File)localFile);){
            long length = IOUtils.copy((InputStream)cosObject.getObjectContent(), (OutputStream)fos);
            logger.info("Remote file:{} download local finish, local file is:{}, transfer length is:{}", new Object[]{getObjectRequest.getKey(), localFile.getAbsolutePath(), length});
        }
        catch (IOException e) {
            logger.error("Remote file download occur exception, cause by:{}", (Object)e.getMessage());
        }
        return false;
    }

    public AbstractUploadStream openUploadStream(String remoteFileName, String remotePath, long size) throws FileSystemException {
        return new CosDefaultOutputStream(this, new CosByteArrayOutputStream(), FilePathUtils.concatFileName((String)remotePath, (String)remoteFileName), size);
    }

    public InputStream openDownloadStream(String remoteFileName, String remotePath) throws FileSystemException {
        GetObjectRequest request = CosFileClientCommand.buildGetObjectRequest(this.bucketName, FilePathUtils.concatFileName((String)remotePath, (String)remoteFileName));
        COSObject cosObject = this.fileClient.client().getObject(request);
        return new CosInputStream(cosObject);
    }

    public boolean delete(String remoteFileName, String remotePath) throws FileSystemException {
        try {
            this.fileClient.client().deleteObject(CosFileClientCommand.buildDeleteObjectRequest(this.bucketName, FilePathUtils.concatFileName((String)remotePath, (String)remoteFileName)));
        }
        catch (CosClientException cosClientException) {
            // empty catch block
        }
        return false;
    }

    public boolean deleteFolder(String remotePath) throws FileSystemException {
        return false;
    }

    public boolean isFileExists(String remoteFileName, String remotePath) {
        ObjectMetadata objectMetadata = this.fileClient.client().getObjectMetadata(this.bucketName, FilePathUtils.concatFileName((String)remotePath, (String)remoteFileName));
        return Objects.nonNull(objectMetadata);
    }

    public boolean isFolderExists(String remotePath) {
        return this.fileClient.client().doesObjectExist(this.bucketName, remotePath);
    }

    public FileInfo queryFileInfo(String remoteFileName, String remotePath) {
        ObjectMetadata objectMetadata = this.fileClient.client().getObjectMetadata(this.bucketName, FilePathUtils.concatFileName((String)remotePath, (String)remoteFileName));
        return null;
    }

    public List<FileInfo> queryFiles(String remotePath) {
        ObjectListing objectListing = this.fileClient.client().listObjects(CosFileClientCommand.buildListObjectsRequest(this.bucketName, remotePath));
        List objectSummaries = objectListing.getObjectSummaries();
        if (CollectionUtils.nonEmpty((Collection)objectSummaries)) {
            LinkedList fileInfos = ListUtils.newLinkedList();
            objectSummaries.forEach(objectSummary -> {});
        }
        return Collections.emptyList();
    }

    public List<String> querySubFolder(String remotePath) {
        return null;
    }

    public boolean move(String fileName, String originPath, String targetFileName, String targetPath, boolean isOverwrite) throws FileSystemException {
        return this.copyOrMove(fileName, originPath, targetFileName, targetPath, isOverwrite, () -> this.delete(originPath, fileName));
    }

    public boolean copy(String fileName, String originPath, String targetFileName, String targetPath, boolean isOverwrite) throws FileSystemException {
        return this.copyOrMove(fileName, originPath, targetFileName, targetPath, isOverwrite, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copyOrMove(String fileName, String originPath, String targetFileName, String targetPath, boolean isOverwrite, Supplier<Boolean> afterOperate) throws FileSystemException {
        GetObjectRequest sourceGetRequest = CosFileClientCommand.buildGetObjectRequest(this.bucketName, FilePathUtils.concatFileName((String)originPath, (String)fileName));
        try (COSObject sourceObject = this.fileClient.client().getObject(sourceGetRequest);){
            if (Objects.isNull(sourceGetRequest)) {
                throw new FileSystemException(String.format("Source file:%s not found!", FilePathUtils.getAbsolutePath((String)originPath, (String)fileName)));
            }
            ObjectMetadata target = this.fileClient.client().getObjectMetadata(this.bucketName, FilePathUtils.concatFileName((String)targetPath, (String)targetFileName));
            if (target == null) return true;
            if (!isOverwrite) {
                throw new FileSystemException(String.format("Source file:%s, copy to target file:%s failure! cause by: target file exist and over write is false!", FilePathUtils.getAbsolutePath((String)originPath, (String)fileName), FilePathUtils.getAbsolutePath((String)targetPath, (String)targetFileName)));
            }
            if (!this.delete(targetFileName, targetPath)) {
                throw new FileSystemException(String.format("delete to target file:%s failure!", FilePathUtils.getAbsolutePath((String)targetPath, (String)targetFileName)));
            }
            PutObjectRequest overwritePutRequest = CosFileClientCommand.buildPutObjectRequest(sourceObject, FilePathUtils.concatFileName((String)targetPath, (String)targetFileName));
            this.fileClient.client().putObject(overwritePutRequest);
            if (!Objects.nonNull(afterOperate)) return true;
            boolean bl = afterOperate.get();
            return bl;
        }
        catch (FileSystemException e) {
            throw e;
        }
        catch (CosClientException | IOException e) {
            throw new FileSystemException(String.format("Source file:%s, copy to target file:%s failure! cause by: %s!", FilePathUtils.getAbsolutePath((String)originPath, (String)fileName), FilePathUtils.getAbsolutePath((String)targetPath, (String)targetFileName), e.getMessage()));
        }
    }

    public boolean available() {
        return false;
    }

    public void close() throws IOException {
    }

    private File localFile(String path, String name) {
        return new File(FilePathUtils.concatFileName((String)path, (String)name));
    }

    protected static PutObjectRequest buildPutObjectRequest(String bucketName, String localFile, String remoteFile) {
        PutObjectRequest request = new PutObjectRequest(bucketName, remoteFile, null);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLanguage(LocaleContextHolder.getLocale().getLanguage());
        String requestId = IdUtils.getId();
        metadata.setRequestId(requestId);
        if (localFile != null) {
            File file = new File(localFile);
            request.setFile(file);
            String localFileName = file.getName();
            String fileSuffix = localFileName.substring(localFileName.lastIndexOf(".") + 1);
            metadata.addUserMetadata("SourceFilename", localFileName);
            metadata.addUserMetadata("Suffix", fileSuffix);
            metadata.addUserMetadata("RequestId", requestId);
            metadata.setContentType(ContentType.getContentType(fileSuffix));
        }
        request.setMetadata(metadata);
        return request;
    }

    protected static PutObjectRequest buildPutObjectRequest(COSObject sourceObject, String remoteFile) {
        PutObjectRequest request = CosFileClientCommand.buildPutObjectRequest(sourceObject.getBucketName(), sourceObject.getObjectMetadata().getUserMetaDataOf("SourceFilename"), remoteFile);
        request.setFile(null);
        request.setInputStream((InputStream)sourceObject.getObjectContent());
        return request;
    }

    protected static GetObjectRequest buildGetObjectRequest(String bucketName, String remoteFile) {
        return new GetObjectRequest(bucketName, remoteFile);
    }

    protected static DeleteObjectRequest buildDeleteObjectRequest(String bucketName, String remoteFile) {
        return new DeleteObjectRequest(bucketName, remoteFile);
    }

    protected static ListObjectsRequest buildListObjectsRequest(String bucketName, String remotePath) {
        ListObjectsRequest request = new ListObjectsRequest();
        request.setBucketName(bucketName);
        if (StringUtils.nonEmpty((CharSequence)remotePath)) {
            request.setPrefix(remotePath);
            request.setDelimiter("/");
        }
        return request;
    }

    protected static FileInfo buildFileInfo(PutObjectResult putObjectResult) {
        return null;
    }

    static class CosInputStream
    extends InputStream {
        private final COSObject cosObject;

        public CosInputStream(COSObject cosObject) {
            this.cosObject = cosObject;
        }

        @Override
        public int read() throws IOException {
            return this.cosObject.getObjectContent().read();
        }

        @Override
        public int available() throws IOException {
            return this.cosObject.getObjectContent().available();
        }

        @Override
        public void close() throws IOException {
            this.cosObject.close();
        }

        @Override
        public synchronized void mark(int readLimit) {
            this.cosObject.getObjectContent().mark(readLimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.cosObject.getObjectContent().reset();
        }

        @Override
        public boolean markSupported() {
            return this.cosObject.getObjectContent().markSupported();
        }
    }

    static class CosByteArrayOutputStream
    extends ByteArrayOutputStream {
        CosByteArrayOutputStream() {
        }
    }

    static class CosDefaultOutputStream
    extends AbstractDefaultOutputStream {
        private final String remoteFile;
        private final CosFileClientCommand fileClientCommand;
        private PutObjectResult putObjectResult;

        public CosDefaultOutputStream(CosFileClientCommand fileClientCommand, OutputStream outputStream, String remoteFile, long maxSize) {
            super(outputStream, maxSize);
            this.remoteFile = remoteFile;
            this.fileClientCommand = fileClientCommand;
        }

        protected void closeError(OutputStream innerStream) throws IOException {
            innerStream.close();
        }

        protected FileInfo closeSuccess(OutputStream innerStream) throws IOException {
            return CosFileClientCommand.buildFileInfo(this.putObjectResult);
        }

        public void close() throws IOException {
            PutObjectRequest request = CosFileClientCommand.buildPutObjectRequest(this.fileClientCommand.bucketName, null, this.remoteFile);
            try (ByteArrayInputStream bis = new ByteArrayInputStream(((ByteArrayOutputStream)this.getInnerStream()).toByteArray());){
                request.setInputStream((InputStream)bis);
                this.putObjectResult = this.fileClientCommand.fileClient.client().putObject(request);
            }
            super.close();
        }
    }
}

