/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.client.tencentcos;

import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ContentType {
    private static final Map<String, String> CONTENT_TYPES = new ConcurrentHashMap<String, String>();
    public static final String IMAGE_BMP = "image/bmp";
    public static final String IMAGE_JPEG = "image/jpeg";
    public static final String IMAGE_GIF = "image/gif";
    public static final String IMAGE_PNG = "image/png";
    public static final String IMAGE_SVG = "image/svg+xml";
    public static final String IMAGE_TIFF = "image/tiff";
    public static final String IMAGE_WEBP = "image/webp";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";

    public static void addContentType(String suffix, String contentType) {
        CONTENT_TYPES.put(suffix, contentType);
    }

    public static String getContentType(String fileSuffix) {
        String suffix = StringUtils.lowerCase((String)fileSuffix);
        String contentType = CONTENT_TYPES.get(suffix);
        return StringUtils.isEmpty((CharSequence)contentType) ? APPLICATION_OCTET_STREAM : contentType;
    }

    public static void addContentTypes(Map<String, String> contentTypes) {
        CONTENT_TYPES.putAll(contentTypes);
    }

    static {
        ContentType.addContentType("jpg", IMAGE_JPEG);
        ContentType.addContentType("jpeg", IMAGE_JPEG);
        ContentType.addContentType("bmp", IMAGE_BMP);
        ContentType.addContentType("gif", IMAGE_GIF);
        ContentType.addContentType("tiff", IMAGE_TIFF);
        ContentType.addContentType("png", IMAGE_PNG);
        ContentType.addContentType("webp", IMAGE_WEBP);
        ContentType.addContentType("SVG", IMAGE_SVG);
    }
}

