/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.model;

import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class IterableModel
implements Iterable<Object> {
    private static final Logger logger = LoggerFactory.getLogger(IterableModel.class);
    private final BiFunction<Integer, Integer, Collection<?>> dataSupplier;
    private int maxPages = 10;
    private int pageSize = 10;
    private Collection<?> firstPage;

    public IterableModel(BiFunction<Integer, Integer, Collection<?>> dataSupplier) {
        this.dataSupplier = dataSupplier;
    }

    public IterableModel(BiFunction<Integer, Integer, Collection<?>> dataSupplier, int maxPages, int pageSize) {
        this.dataSupplier = dataSupplier;
        this.maxPages = maxPages;
        this.pageSize = pageSize;
    }

    public IterableModel(BiFunction<Integer, Integer, Collection<?>> dataSupplier, int maxPages, int pageSize, Collection<?> firstPage) {
        this.dataSupplier = dataSupplier;
        this.maxPages = maxPages;
        this.pageSize = pageSize;
        if (firstPage == null) {
            this.firstPage = null;
        } else {
            if (firstPage.isEmpty()) {
                throw new IllegalStateException("First page can not be empty");
            }
            this.firstPage = firstPage;
        }
    }

    public BiFunction<Integer, Integer, Collection<?>> getDataSupplier() {
        return this.dataSupplier;
    }

    public void setFirstPage(Collection<?> firstPage) {
        this.firstPage = firstPage;
    }

    @Override
    @NonNull
    public Iterator<Object> iterator() {
        return new Iter();
    }

    private class Iter
    implements Iterator<Object> {
        private Collection<?> nextPage;
        private Iterator<?> current;
        private int pageNum = 0;

        public Iter() {
            if (CollectionUtils.nonEmpty((Collection)IterableModel.this.firstPage)) {
                this.nextPage = IterableModel.this.firstPage;
                ++this.pageNum;
            } else {
                this.nextPage();
            }
        }

        @Override
        public boolean hasNext() {
            boolean existRecord;
            boolean bl = existRecord = this.current != null && this.current.hasNext();
            if (existRecord) {
                return true;
            }
            if (this.nextPage.isEmpty()) {
                if (logger.isInfoEnabled()) {
                    if (this.pageNum == IterableModel.this.maxPages) {
                        logger.info("Reached maxPages:{},stop search.", (Object)IterableModel.this.maxPages);
                    } else {
                        logger.info("db not exists more records, maxPages:{},currentPage:{} skip search.", (Object)IterableModel.this.maxPages, (Object)this.pageNum);
                    }
                }
                return false;
            }
            return true;
        }

        @Override
        public Object next() {
            if (this.current == null || !this.current.hasNext()) {
                logger.debug("Current query page {}", (Object)this.pageNum);
                this.nextPage();
            }
            if (this.current == null) {
                throw new NoSuchElementException("can not find");
            }
            return this.current.next();
        }

        private void nextPage() {
            if (this.nextPage != null) {
                this.current = this.nextPage.iterator();
            }
            if (IterableModel.this.maxPages < 0) {
                ++this.pageNum;
                this.nextPage = (Collection)IterableModel.this.dataSupplier.apply(this.pageNum, IterableModel.this.pageSize);
            } else if (this.pageNum < IterableModel.this.maxPages) {
                ++this.pageNum;
                this.nextPage = Optional.ofNullable((Collection)IterableModel.this.dataSupplier.apply(this.pageNum, IterableModel.this.pageSize)).orElse(new ArrayList());
            } else {
                this.nextPage = new ArrayList();
            }
        }
    }
}

