/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.easyexcel;

import cn.com.yusys.yusp.commons.excelcsv.easyexcel.LocalDateConverter;
import cn.com.yusys.yusp.commons.excelcsv.easyexcel.LocalDateTimeConverter;
import cn.com.yusys.yusp.commons.excelcsv.handle.DataHandle;
import cn.com.yusys.yusp.commons.excelcsv.handle.HeadProperty;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.WriteContext;
import com.alibaba.excel.enums.HeadKindEnum;
import com.alibaba.excel.enums.WriteTypeEnum;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.util.WorkBookUtil;
import com.alibaba.excel.util.WriteHandlerUtils;
import com.alibaba.excel.write.executor.AbstractExcelWriteExecutor;
import com.alibaba.excel.write.handler.context.CellWriteHandlerContext;
import com.alibaba.excel.write.handler.context.RowWriteHandlerContext;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.holder.WriteHolder;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.property.ExcelWriteHeadProperty;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.beans.BeanMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YuExcelWriteAddExecutor
extends AbstractExcelWriteExecutor {
    private static final Logger log = LoggerFactory.getLogger(YuExcelWriteAddExecutor.class);
    private final int sheetMaxRow;
    private final DataHandle dataHandle;
    private int sheetNo = 0;
    private int newRowIndex;
    private int relativeRowIndex = 0;
    private final HeadProperty headProperty;
    private final Map<Field, CellStyle> cellStyleCache = new ConcurrentHashMap<Field, CellStyle>(8);

    public YuExcelWriteAddExecutor(WriteContext writeContext, HeadProperty headProperty, int sheetMaxRow, DataHandle dataHandle) {
        super(writeContext);
        if (headProperty == null || headProperty.getNotIgnoreHeadInfos() == null || headProperty.getNotIgnoreHeadInfos().isEmpty() || headProperty.getExcelCsvHeads() == null || headProperty.getExcelCsvHeads().isEmpty()) {
            throw new IllegalStateException("excel heads can not be null or empty");
        }
        this.headProperty = headProperty;
        this.sheetMaxRow = sheetMaxRow;
        this.dataHandle = dataHandle;
    }

    public void add(Object data) {
        if (data == null) {
            throw new NullPointerException("The data can not be null.");
        }
        TreeMap<Integer, Field> sortedAllFiledMap = new TreeMap<Integer, Field>();
        this.analysisHead();
        this.createNewSheet();
        if (data instanceof Iterable) {
            Iterable objects = (Iterable)data;
            for (Object rowData : objects) {
                if (this.relativeRowIndex == this.sheetMaxRow) {
                    this.analysisHead();
                    this.createNewSheet();
                }
                this.doDataWrite(sortedAllFiledMap, rowData);
            }
        } else {
            this.doDataWrite(sortedAllFiledMap, data);
        }
    }

    private void doDataWrite(Map<Integer, Field> sortedAllFiledMap, Object oneRowData) {
        if ((oneRowData = this.dataHandle.handle(oneRowData, DataHandle.OperationType.EXPORT)) == null) {
            log.warn("return null value after custom handle while export excel file, skip.");
            return;
        }
        int n = this.relativeRowIndex + this.newRowIndex;
        this.addOneRowOfDataToExcel(oneRowData, n, this.relativeRowIndex, sortedAllFiledMap);
        ++this.relativeRowIndex;
    }

    private void analysisHead() {
        if (this.headProperty == null || this.headProperty.getExcelCsvHeads() == null || this.headProperty.getExcelCsvHeads().isEmpty()) {
            return;
        }
        ExcelWriteHeadProperty writeHeadProperty = this.writeContext.currentWriteHolder().excelWriteHeadProperty();
        writeHeadProperty.setHeadClazz(this.headProperty.getHeadClazz());
        writeHeadProperty.setHeadKind(HeadKindEnum.CLASS);
        writeHeadProperty.setHeadMap(this.headProperty.getHeadMap());
        writeHeadProperty.setIgnoreMap(this.headProperty.getIgnoreMap());
        writeHeadProperty.setHeadRowNumber(this.getHeadRowNumber());
    }

    private int getHeadRowNumber() {
        int headRowNumber = 1;
        for (Head head : this.headProperty.getHeadMap().values()) {
            if (CollectionUtils.isEmpty((Collection)head.getHeadNameList()) || headRowNumber >= head.getHeadNameList().size()) continue;
            headRowNumber = head.getHeadNameList().size();
        }
        return headRowNumber;
    }

    private void createNewSheet() {
        WriteSheet writeSheet = EasyExcel.writerSheet((Integer)this.sheetNo, (String)("Sheet" + (this.sheetNo + 1))).build();
        writeSheet.setCustomConverterList(Arrays.asList(new LocalDateConverter(), new LocalDateTimeConverter()));
        if (this.headProperty != null && !this.headProperty.getHeadNames().isEmpty()) {
            this.writeContext.writeWorkbookHolder().setHead(this.headProperty.getHeadNames());
        }
        this.writeContext.currentSheet(writeSheet, WriteTypeEnum.ADD);
        this.newRowIndex = this.getNewRowIndex();
        this.relativeRowIndex = 0;
        ++this.sheetNo;
    }

    private int getNewRowIndex() {
        WriteSheetHolder writeSheetHolder = this.writeContext.writeSheetHolder();
        int newRowIndex = writeSheetHolder.getNewRowIndexAndStartDoWrite();
        if (writeSheetHolder.isNew() && !writeSheetHolder.getExcelWriteHeadProperty().hasHead()) {
            newRowIndex += this.writeContext.currentWriteHolder().relativeHeadRowIndex();
        }
        return newRowIndex;
    }

    private void addOneRowOfDataToExcel(Object oneRowData, int n, int relativeRowIndex, Map<Integer, Field> sortedAllFiledMap) {
        if (oneRowData == null) {
            return;
        }
        RowWriteHandlerContext before = new RowWriteHandlerContext(this.writeContext, this.writeContext.writeWorkbookHolder(), this.writeContext.writeSheetHolder(), this.writeContext.writeTableHolder(), Integer.valueOf(n), null, Integer.valueOf(relativeRowIndex), Boolean.FALSE);
        WriteHandlerUtils.beforeRowCreate((RowWriteHandlerContext)before);
        Row row = WorkBookUtil.createRow((Sheet)this.writeContext.writeSheetHolder().getSheet(), (int)n);
        RowWriteHandlerContext after = new RowWriteHandlerContext(this.writeContext, this.writeContext.writeWorkbookHolder(), this.writeContext.writeSheetHolder(), this.writeContext.writeTableHolder(), Integer.valueOf(n), row, Integer.valueOf(relativeRowIndex), Boolean.FALSE);
        WriteHandlerUtils.afterRowCreate((RowWriteHandlerContext)after);
        if (oneRowData instanceof List) {
            this.addBasicTypeToExcel((List)oneRowData, row, relativeRowIndex);
        } else {
            this.addJavaObjectToExcel(oneRowData, row, relativeRowIndex, sortedAllFiledMap);
        }
        RowWriteHandlerContext dispose = new RowWriteHandlerContext(this.writeContext, this.writeContext.writeWorkbookHolder(), this.writeContext.writeSheetHolder(), this.writeContext.writeTableHolder(), Integer.valueOf(n), row, Integer.valueOf(relativeRowIndex), Boolean.FALSE);
        WriteHandlerUtils.afterRowDispose((RowWriteHandlerContext)dispose);
    }

    private void addBasicTypeToExcel(List<Object> oneRowData, Row row, int relativeRowIndex) {
        if (CollectionUtils.isEmpty(oneRowData)) {
            return;
        }
        Map headMap = this.writeContext.currentWriteHolder().excelWriteHeadProperty().getHeadMap();
        int dataIndex = 0;
        int cellIndex = 0;
        ArrayList cellDataList = new ArrayList();
        for (Map.Entry entry : headMap.entrySet()) {
            if (dataIndex >= oneRowData.size()) {
                return;
            }
            cellIndex = (Integer)entry.getKey();
            Head head = (Head)entry.getValue();
            this.doAddBasicTypeToExcel(oneRowData, head, row, relativeRowIndex, dataIndex++, cellIndex, cellDataList);
        }
        if (dataIndex >= oneRowData.size()) {
            return;
        }
        if (cellIndex != 0) {
            ++cellIndex;
        }
        int size = oneRowData.size() - dataIndex;
        for (int i = 0; i < size; ++i) {
            this.doAddBasicTypeToExcel(oneRowData, null, row, relativeRowIndex, dataIndex++, cellIndex++, cellDataList);
        }
    }

    private void doAddBasicTypeToExcel(List<Object> oneRowData, Head head, Row row, int relativeRowIndex, int dataIndex, int cellIndex, List<WriteCellData<?>> cellDataList) {
        if (this.writeContext.currentWriteHolder().ignore(null, Integer.valueOf(cellIndex))) {
            return;
        }
        ExcelContentProperty property = this.headProperty.getContentPropertyMap().get(cellIndex);
        CellWriteHandlerContext before = new CellWriteHandlerContext(this.writeContext, this.writeContext.writeWorkbookHolder(), this.writeContext.writeSheetHolder(), this.writeContext.writeTableHolder(), row, Integer.valueOf(row.getRowNum() - 1), null, Integer.valueOf(cellIndex), Integer.valueOf(relativeRowIndex), head, cellDataList, CollectionUtils.isEmpty(cellDataList) ? null : cellDataList.get(0), Boolean.FALSE, property);
        WriteHandlerUtils.beforeCellCreate((CellWriteHandlerContext)before);
        Cell cell = WorkBookUtil.createCell((Row)row, (int)cellIndex);
        Object value = oneRowData.get(dataIndex);
        WriteCellData writeCellData = new WriteCellData();
        writeCellData.setData(value);
        cellDataList.add(writeCellData);
        CellWriteHandlerContext after = new CellWriteHandlerContext(this.writeContext, this.writeContext.writeWorkbookHolder(), this.writeContext.writeSheetHolder(), this.writeContext.writeTableHolder(), row, Integer.valueOf(row.getRowNum() - 1), cell, Integer.valueOf(cellIndex), Integer.valueOf(relativeRowIndex), head, cellDataList, cellDataList.get(0), Boolean.FALSE, property);
        WriteHandlerUtils.afterCellCreate((CellWriteHandlerContext)after);
        CellWriteHandlerContext dispose = new CellWriteHandlerContext(this.writeContext, this.writeContext.writeWorkbookHolder(), this.writeContext.writeSheetHolder(), this.writeContext.writeTableHolder(), row, Integer.valueOf(row.getRowNum() - 1), cell, Integer.valueOf(cellIndex), Integer.valueOf(relativeRowIndex), head, cellDataList, cellDataList.get(0), Boolean.FALSE, property);
        dispose.setOriginalValue(value);
        dispose.setOriginalFieldClass(value.getClass());
        this.converterAndSet(dispose);
        WriteHandlerUtils.afterCellDispose((CellWriteHandlerContext)dispose);
    }

    private void addJavaObjectToExcel(Object oneRowData, Row row, int relativeRowIndex, Map<Integer, Field> sortedAllFiledMap) {
        WriteHolder currentWriteHolder = this.writeContext.currentWriteHolder();
        BeanMap beanMap = BeanMap.create((Object)oneRowData);
        ArrayList<WriteCellData> cellDataList = new ArrayList<WriteCellData>();
        int cellIndex = 0;
        if (HeadKindEnum.CLASS.equals((Object)this.writeContext.currentWriteHolder().excelWriteHeadProperty().getHeadKind())) {
            Map headMap = this.writeContext.currentWriteHolder().excelWriteHeadProperty().getHeadMap();
            Map<Integer, ExcelContentProperty> contentPropertyMap = this.headProperty.getContentPropertyMap();
            for (Map.Entry<Integer, ExcelContentProperty> entry : contentPropertyMap.entrySet()) {
                cellIndex = entry.getKey();
                ExcelContentProperty excelContentProperty = entry.getValue();
                String name = excelContentProperty.getField().getName();
                if (this.writeContext.currentWriteHolder().ignore(name, Integer.valueOf(cellIndex)) || !beanMap.containsKey((Object)name)) continue;
                Head head = (Head)headMap.get(cellIndex);
                Object value = beanMap.get((Object)name);
                CellWriteHandlerContext before = new CellWriteHandlerContext(this.writeContext, this.writeContext.writeWorkbookHolder(), this.writeContext.writeSheetHolder(), this.writeContext.writeTableHolder(), row, Integer.valueOf(row.getRowNum() - 1), null, Integer.valueOf(cellIndex), Integer.valueOf(relativeRowIndex), head, cellDataList, CollectionUtils.isEmpty(cellDataList) ? null : (WriteCellData)cellDataList.get(0), Boolean.FALSE, excelContentProperty);
                WriteHandlerUtils.beforeCellCreate((CellWriteHandlerContext)before);
                Cell cell = WorkBookUtil.createCell((Row)row, (int)cellIndex);
                WriteCellData writeCellData = new WriteCellData();
                writeCellData.setData(value);
                cellDataList.add(writeCellData);
                CellWriteHandlerContext after = new CellWriteHandlerContext(this.writeContext, this.writeContext.writeWorkbookHolder(), this.writeContext.writeSheetHolder(), this.writeContext.writeTableHolder(), row, Integer.valueOf(row.getRowNum() - 1), cell, Integer.valueOf(cellIndex), Integer.valueOf(relativeRowIndex), head, cellDataList, (WriteCellData)cellDataList.get(0), Boolean.FALSE, excelContentProperty);
                WriteHandlerUtils.afterCellCreate((CellWriteHandlerContext)after);
                String exportCellStyle = this.headProperty.getExcelCsvHeads().get(cellIndex).getExportCellStyle();
                if (StringUtils.isEmpty((CharSequence)exportCellStyle)) {
                    CellWriteHandlerContext dispose = new CellWriteHandlerContext(this.writeContext, this.writeContext.writeWorkbookHolder(), this.writeContext.writeSheetHolder(), this.writeContext.writeTableHolder(), row, Integer.valueOf(row.getRowNum() - 1), cell, Integer.valueOf(cellIndex), Integer.valueOf(relativeRowIndex), head, cellDataList, (WriteCellData)cellDataList.get(0), Boolean.FALSE, excelContentProperty);
                    dispose.setOriginalValue(value);
                    if (Objects.nonNull(value)) {
                        dispose.setOriginalFieldClass(value.getClass());
                    }
                    this.converterAndSet(dispose);
                    WriteHandlerUtils.afterCellDispose((CellWriteHandlerContext)dispose);
                    if (excelContentProperty.getNumberFormatProperty() == null || !excelContentProperty.getNumberFormatProperty().getFormat().replaceAll("[(#,.0)]", "").isEmpty()) continue;
                    DataFormat dataFormat = this.writeContext.writeWorkbookHolder().getWorkbook().createDataFormat();
                    CellStyle style = this.cellStyleCache.computeIfAbsent(excelContentProperty.getField(), field -> this.writeContext.writeWorkbookHolder().getWorkbook().createCellStyle());
                    style.setDataFormat(dataFormat.getFormat(excelContentProperty.getNumberFormatProperty().getFormat()));
                    cell.setCellStyle(style);
                    continue;
                }
                Workbook workbook = cell.getRow().getSheet().getWorkbook();
                if (value instanceof LocalDateTime) {
                    Date date = Date.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant());
                    cell.setCellValue(date);
                }
                if (value instanceof Date) {
                    cell.setCellValue((Date)value);
                }
                if (value instanceof BigDecimal) {
                    String s = value.toString();
                    if (s.length() >= 15) {
                        cell.setCellValue(s);
                    } else {
                        cell.setCellValue(((BigDecimal)value).doubleValue());
                    }
                }
                if (value instanceof Integer || value instanceof Long) {
                    if (value.toString().length() <= 15) {
                        cell.setCellValue(Double.valueOf(value.toString()).doubleValue());
                    } else {
                        cell.setCellValue(value.toString());
                    }
                }
                if (value instanceof String) {
                    cell.setCellValue((String)value);
                }
                CellStyle cellStyle = workbook.createCellStyle();
                DataFormat format = workbook.createDataFormat();
                cellStyle.setDataFormat(format.getFormat(exportCellStyle));
                cell.setCellStyle(cellStyle);
            }
        }
    }
}

