/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.easyexcel;

import cn.com.yusys.yusp.commons.util.date.DateUtils;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.CellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class TimestampConverter
implements Converter<Timestamp> {
    private final DateTimeFormatter formatter;
    private static final String DEFAULT_DATE_FORMAT = DateUtils.PATTERN_DATETIME;

    public TimestampConverter() {
        this.formatter = DateTimeFormatter.ofPattern(DEFAULT_DATE_FORMAT);
    }

    public TimestampConverter(String format) {
        this.formatter = format != null && !format.isEmpty() ? DateTimeFormatter.ofPattern(format) : DateTimeFormatter.ofPattern(DEFAULT_DATE_FORMAT);
    }

    public Class supportJavaTypeKey() {
        return Timestamp.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public Timestamp convertToJavaData(CellData cellData, ExcelContentProperty property, GlobalConfiguration globalConfiguration) {
        if (cellData.getStringValue() == null || cellData.getStringValue().isEmpty()) {
            return null;
        }
        return new Timestamp(Date.from(LocalDateTime.from(this.formatter.parse(cellData.getStringValue())).atZone(ZoneId.systemDefault()).toInstant()).getTime());
    }

    public WriteCellData<?> convertToExcelData(Timestamp timestamp, ExcelContentProperty property, GlobalConfiguration globalConfiguration) {
        if (timestamp == null) {
            return new WriteCellData("");
        }
        return new WriteCellData(this.formatter.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp.getTime()), ZoneId.systemDefault())));
    }
}

