/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.easyexcel;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.CellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class LocalDateConverter
implements Converter<LocalDate> {
    private DateTimeFormatter formatter;
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";

    public LocalDateConverter() {
        this.formatter = DateTimeFormatter.ofPattern(DEFAULT_DATE_FORMAT);
    }

    public LocalDateConverter(String format) {
        this.formatter = format != null && !format.isEmpty() ? DateTimeFormatter.ofPattern(format) : DateTimeFormatter.ofPattern(DEFAULT_DATE_FORMAT);
    }

    public Class<LocalDate> supportJavaTypeKey() {
        return LocalDate.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public LocalDate convertToJavaData(CellData cellData, ExcelContentProperty property, GlobalConfiguration globalConfiguration) throws Exception {
        if (cellData.getStringValue() == null || cellData.getStringValue().isEmpty()) {
            return null;
        }
        return LocalDate.parse(cellData.getStringValue(), this.formatter);
    }

    public WriteCellData<?> convertToExcelData(LocalDate localDate, ExcelContentProperty property, GlobalConfiguration globalConfiguration) throws Exception {
        if (localDate == null) {
            return new WriteCellData("");
        }
        return new WriteCellData(this.formatter.format(localDate));
    }
}

