/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv;

import cn.com.yusys.yusp.commons.excelcsv.CsvTemplate;
import cn.com.yusys.yusp.commons.excelcsv.ExcelTemplate;
import cn.com.yusys.yusp.commons.excelcsv.ITemplate;
import cn.com.yusys.yusp.commons.excelcsv.annotation.ExcelCsv;
import cn.com.yusys.yusp.commons.excelcsv.async.DefaultDataHandle;
import cn.com.yusys.yusp.commons.excelcsv.async.Visitor;
import cn.com.yusys.yusp.commons.excelcsv.handle.DataHandle;
import cn.com.yusys.yusp.commons.excelcsv.handle.impl.AbstractExcelFieldDataHandle;
import cn.com.yusys.yusp.commons.module.standard.Dicts;
import cn.com.yusys.yusp.commons.util.IdUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExporterImporter {
    private static final Logger log = LoggerFactory.getLogger(ExporterImporter.class);
    public static final AbstractExcelFieldDataHandle DEFAULT_DATA_HANDLE = new DefaultDataHandle();
    private int sheetMaxRow;
    private String tempDir;

    public ExporterImporter() {
    }

    public ExporterImporter(int sheetMaxRow, String tempDir) {
        this.sheetMaxRow = sheetMaxRow;
        this.tempDir = tempDir;
    }

    public File export(Class<?> headClass, Object model) {
        return this.export(headClass, model, DEFAULT_DATA_HANDLE);
    }

    public File export(Class<?> headClass, Object model, DataHandle dataHandle) {
        return this.simpleExport(headClass, model, dataHandle);
    }

    private File simpleExport(Class<?> headClass, Object model, DataHandle dataHandle) {
        Objects.requireNonNull(headClass, "headClass can not be null.");
        Objects.requireNonNull(model, "model can not be null.");
        Objects.requireNonNull(dataHandle, "dataHandle can not be null.");
        try {
            ITemplate iTemplate;
            File outFile = this.getOutFile(headClass);
            if (outFile.getName().endsWith(ExcelCsv.ExportFileType.CSV.getType())) {
                log.info("export csv file. temp file path:{}", (Object)outFile.getAbsoluteFile());
                iTemplate = new CsvTemplate(headClass, dataHandle);
            } else {
                log.info("export excel file. temp file path:{}", (Object)outFile.getAbsoluteFile());
                iTemplate = new ExcelTemplate(headClass, this.sheetMaxRow, dataHandle);
            }
            iTemplate.export(model, outFile);
            File file = outFile;
            return file;
        }
        catch (Exception e) {
            throw new IllegalStateException("export failed.", e);
        }
        finally {
            Dicts.clearThreadLocal();
        }
    }

    public void importData(Class<?> headClass, File inFile, Consumer<Object> handleFun) {
        this.importData(headClass, inFile, DEFAULT_DATA_HANDLE, handleFun);
    }

    public void importData(Class<?> headClass, File inFile, DataHandle dataHandle, Consumer<Object> handleFun) {
        this.importData(headClass, inFile, dataHandle, handleFun, Visitor.NULL_VISITOR);
    }

    public void importData(Class<?> headClass, File inFile, DataHandle dataHandle, Consumer<Object> handleFun, Visitor<Object> visitor) {
        block7: {
            Objects.requireNonNull(headClass, "headClass can not be null.");
            Objects.requireNonNull(inFile, "file can not be null.");
            Objects.requireNonNull(dataHandle, "dataHandle can not be null.");
            Objects.requireNonNull(handleFun, "handleFun can not be null.");
            try {
                String fileName = inFile.getName().toLowerCase();
                if (fileName.endsWith(ExcelCsv.ExportFileType.CSV.getType())) {
                    CsvTemplate csvTemplate = new CsvTemplate(headClass, dataHandle);
                    csvTemplate.importData(inFile, handleFun, visitor);
                    break block7;
                }
                if (fileName.endsWith(ExcelCsv.ExportFileType.XLS.getType()) || fileName.endsWith(ExcelCsv.ExportFileType.XLSX.getType())) {
                    ExcelTemplate excelTemplate = new ExcelTemplate(headClass, dataHandle);
                    excelTemplate.importData(inFile, handleFun, visitor);
                    break block7;
                }
                throw new IllegalArgumentException("the file type " + fileName + " is not supported.");
            }
            catch (Exception e) {
                throw new IllegalStateException("import error.", e);
            }
            finally {
                Dicts.clearThreadLocal();
            }
        }
    }

    private File getOutFile(Class<?> headClass) throws IOException {
        if (headClass.isAnnotationPresent(ExcelCsv.class)) {
            ExcelCsv excel = headClass.getAnnotation(ExcelCsv.class);
            return this.createTempFile(excel.namePrefix() + "-", excel.fileType().getType());
        }
        return this.createTempFile("excel-export-", ".xlsx");
    }

    private File createTempFile(String prefix, String suffix) throws IOException {
        if (StringUtils.isEmpty((CharSequence)this.tempDir)) {
            return File.createTempFile(prefix, suffix);
        }
        String path = StringUtils.builder0((Object[])new Object[]{this.tempDir, File.separator, prefix, IdUtils.getId(), suffix});
        FileUtils.createFile((String)path);
        return new File(path);
    }
}

