/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.util;

import cn.com.yusys.yusp.commons.excelcsv.BillTemplate;
import cn.com.yusys.yusp.commons.excelcsv.handle.DataHandle;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.jxls.transform.poi.WritableHyperlink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonFunctions {
    private static final Logger log = LoggerFactory.getLogger(CommonFunctions.class);
    private final Map<String, Dict> DICT_CACHE = new ConcurrentHashMap<String, Dict>();
    private final DataHandle dataHandle;

    public CommonFunctions(DataHandle dataHandle) {
        this.dataHandle = dataHandle;
    }

    public String dict(String src, String lookupCode) {
        return this.translateDict(lookupCode, src);
    }

    public String dict(String src, String lookupCode, String defaultValue) {
        String translateValue = this.translateDict(lookupCode, src);
        return translateValue.equals(src) ? defaultValue : translateValue;
    }

    public WritableHyperlink makeLink(Object obj, String value, String targetSheetName, String keyFields) {
        String address = "'" + targetSheetName + "'!" + BillTemplate.keyFields2Key(obj, keyFields);
        return new WritableHyperlink(address, value, HyperlinkType.DOCUMENT);
    }

    private String translateDict(String dictCode, String srcValue) {
        if (StringUtils.isBlank((CharSequence)dictCode) || StringUtils.isBlank((CharSequence)srcValue)) {
            return srcValue;
        }
        if (this.dataHandle == null) {
            log.warn("the data handle is null, will not translate.");
            return srcValue;
        }
        String[] dictAndLang = dictCode.split("\\$");
        dictCode = dictAndLang[0];
        String langCode = dictAndLang.length == 1 ? "CN" : dictAndLang[1];
        Dict dict = this.DICT_CACHE.get(dictCode + "$" + srcValue);
        if (dict == null) {
            dict = new Dict(dictCode, srcValue);
            Object obj = this.dataHandle.handle(dict, DataHandle.OperationType.EXPORT);
            if (obj == null || obj.getClass() != Dict.class) {
                return srcValue;
            }
            dict = (Dict)obj;
            this.DICT_CACHE.put(dictCode + "$" + srcValue, dict);
        }
        String result = "EN".equalsIgnoreCase(langCode) ? dict.getItemValueEn() : dict.getItemValue();
        result = result == null ? srcValue : result;
        return result;
    }

    public static class Dict {
        private String dictCode;
        private String srcValue;
        private String itemValue;
        private String itemValueEn;

        public Dict(String dictCode, String srcValue) {
            this.dictCode = dictCode;
            this.srcValue = srcValue;
        }

        public String getDictCode() {
            return this.dictCode;
        }

        public void setDictCode(String dictCode) {
            this.dictCode = dictCode;
        }

        public String getSrcValue() {
            return this.srcValue;
        }

        public void setSrcValue(String srcValue) {
            this.srcValue = srcValue;
        }

        public String getItemValue() {
            return this.itemValue;
        }

        public void setItemValue(String itemValue) {
            this.itemValue = itemValue;
        }

        public String getItemValueEn() {
            return this.itemValueEn;
        }

        public void setItemValueEn(String itemValueEn) {
            this.itemValueEn = itemValueEn;
        }
    }
}

