/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.handle;

import cn.com.yusys.yusp.commons.excelcsv.easyexcel.LocalDateConverter;
import cn.com.yusys.yusp.commons.excelcsv.easyexcel.LocalDateTimeConverter;
import cn.com.yusys.yusp.commons.excelcsv.easyexcel.LocalTimeConverter;
import cn.com.yusys.yusp.commons.excelcsv.handle.ExcelCsvHead;
import cn.com.yusys.yusp.commons.util.CommonUtils;
import cn.com.yusys.yusp.commons.util.ReflectionUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ConverterKeyBuild;
import com.alibaba.excel.converters.DefaultConverterLoader;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.property.ColumnWidthProperty;
import com.alibaba.excel.metadata.property.DateTimeFormatProperty;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.metadata.property.NumberFormatProperty;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadProperty {
    private static final Logger log = LoggerFactory.getLogger(HeadProperty.class);
    private final Class<?> headClazz;
    private final List<ExcelCsvHead> excelCsvHeads;
    private Set<String> includeHeads = new HashSet<String>();
    private Set<String> excludeHeads = new HashSet<String>();
    private final List<ExcelCsvHead> notIgnoreHeadInfos = new ArrayList<ExcelCsvHead>();
    private final Map<Integer, Head> headMap = new TreeMap<Integer, Head>();
    private final Map<Integer, ExcelContentProperty> contentPropertyMap = new TreeMap<Integer, ExcelContentProperty>();
    private final Map<String, ExcelContentProperty> fieldNameContentPropertyMap = new HashMap<String, ExcelContentProperty>(8);
    private final Map<String, Field> ignoreMap = new HashMap<String, Field>();
    private final List<List<String>> headNames = new ArrayList<List<String>>();

    public HeadProperty(Class<?> headClazz, List<ExcelCsvHead> excelCsvHeads) {
        Objects.requireNonNull(headClazz, "head class can not be null.");
        Objects.requireNonNull(excelCsvHeads, "head list class can not be null.");
        this.headClazz = headClazz;
        this.excelCsvHeads = excelCsvHeads;
    }

    void initNeedExportHead(ExcelCsvHead excelCsvHead, Field field) {
        this.notIgnoreHeadInfos.add(excelCsvHead);
        Head head = new Head(excelCsvHead.getColumnIndex(), excelCsvHead.getFieldName(), Collections.singletonList(excelCsvHead.getTitle()), Boolean.valueOf(true), Boolean.valueOf(true));
        head.setColumnWidthProperty(new ColumnWidthProperty(Integer.valueOf(excelCsvHead.getColumnWidth())));
        this.headMap.put(excelCsvHead.getColumnIndex(), head);
        this.headNames.add(head.getHeadNameList());
        ExcelContentProperty contentProperty = new ExcelContentProperty();
        contentProperty.setHead(head);
        contentProperty.setField(field);
        Class<?> fieldType = field.getType();
        if (excelCsvHead.getFormatType() != null) {
            if (excelCsvHead.getFormatType() == ExcelCsvHead.FormatType.DATE && Date.class == field.getType()) {
                contentProperty.setDateTimeFormatProperty(new DateTimeFormatProperty(excelCsvHead.getFormat(), Boolean.valueOf(false)));
            } else if (excelCsvHead.getFormatType() == ExcelCsvHead.FormatType.NUM) {
                NumberFormatProperty formatProperty = new NumberFormatProperty(excelCsvHead.getFormat(), RoundingMode.HALF_UP);
                contentProperty.setNumberFormatProperty(formatProperty);
                CellDataTypeEnum cellType = excelCsvHead.getFormat().replaceAll("[#,.0]", "").length() > 0 ? CellDataTypeEnum.STRING : CellDataTypeEnum.NUMBER;
                contentProperty.setConverter((Converter)DefaultConverterLoader.loadAllConverter().get(ConverterKeyBuild.buildKey(field.getType(), (CellDataTypeEnum)cellType)));
            }
        } else if (BigDecimal.class.equals(fieldType)) {
            contentProperty.setConverter((Converter)DefaultConverterLoader.loadAllConverter().get(ConverterKeyBuild.buildKey(field.getType(), (CellDataTypeEnum)CellDataTypeEnum.STRING)));
        }
        if (field.getType() == LocalDate.class) {
            contentProperty.setConverter((Converter)new LocalDateConverter(excelCsvHead.getFormat()));
        } else if (field.getType() == LocalDateTime.class) {
            contentProperty.setConverter((Converter)new LocalDateTimeConverter(excelCsvHead.getFormat()));
        } else if (field.getType() == LocalTime.class) {
            contentProperty.setConverter((Converter)new LocalTimeConverter(excelCsvHead.getFormat()));
        } else {
            this.ignoreMap.put(excelCsvHead.getFieldName(), field);
        }
        this.contentPropertyMap.put(excelCsvHead.getColumnIndex(), contentProperty);
        this.fieldNameContentPropertyMap.put(excelCsvHead.getFieldName(), contentProperty);
    }

    public void setIncludeColumns(Set<String> columns) {
        if (CommonUtils.isNullOrEmpty(columns)) {
            log.debug("empty export columns,don't set.");
            return;
        }
        log.debug("custom includes columns:{}", columns);
        this.includeHeads.addAll(columns);
    }

    public void setExcludeColumns(Set<String> columns) {
        if (CommonUtils.nonNullOrEmpty(columns)) {
            log.debug("add custom ignore export columns:{}", columns);
        }
        this.excludeHeads.addAll(columns);
    }

    public Class<?> getHeadClazz() {
        return this.headClazz;
    }

    public List<ExcelCsvHead> getExcelCsvHeads() {
        return this.excelCsvHeads;
    }

    public List<ExcelCsvHead> getNotIgnoreHeadInfos() {
        return this.notIgnoreHeadInfos;
    }

    public Map<Integer, Head> getHeadMap() {
        return this.headMap;
    }

    public Map<Integer, ExcelContentProperty> getContentPropertyMap() {
        return this.contentPropertyMap;
    }

    public Map<String, ExcelContentProperty> getFieldNameContentPropertyMap() {
        return this.fieldNameContentPropertyMap;
    }

    public Map<String, Field> getIgnoreMap() {
        return this.ignoreMap;
    }

    public List<List<String>> getHeadNames() {
        return this.headNames;
    }

    public HeadProperty build() {
        if (CollectionUtils.isEmpty(this.excelCsvHeads)) {
            return this;
        }
        this.excelCsvHeads.sort(Comparator.comparing(ExcelCsvHead::getColumnIndex));
        int index = 0;
        for (ExcelCsvHead excelCsvHead : this.excelCsvHeads) {
            if (!this.initExcelCsvHead(excelCsvHead, index)) continue;
            ++index;
        }
        return this;
    }

    private boolean initExcelCsvHead(ExcelCsvHead excelCsvHead, int index) {
        Field field;
        String fieldName = excelCsvHead.getFieldName();
        try {
            field = ReflectionUtils.getDeclaredField(this.headClazz, (String)fieldName);
        }
        catch (Exception e) {
            throw new IllegalStateException("can not find field " + excelCsvHead.getFieldName(), e);
        }
        Objects.requireNonNull(field, "can not find field " + excelCsvHead.getFieldName());
        if (!this.isNeedExport(excelCsvHead)) {
            this.ignoreMap.put(fieldName, field);
            return false;
        }
        excelCsvHead.setColumnIndex(index);
        this.initNeedExportHead(excelCsvHead, field);
        return true;
    }

    private boolean isNeedExport(ExcelCsvHead excelCsvHead) {
        return excelCsvHead.getColumnIndex() >= 0 && (this.includeHeads.isEmpty() || this.includeHeads.contains(excelCsvHead.getFieldName())) && !this.excludeHeads.contains(excelCsvHead.getFieldName());
    }

    public String toString() {
        return "HeadProperty{headClazz=" + this.headClazz + ", excelCsvHeads=" + this.excelCsvHeads + ", includeHeads=" + this.includeHeads + ", excludeHeads=" + this.excludeHeads + ", notIgnoreHeadInfos=" + this.notIgnoreHeadInfos + ", headMap=" + this.headMap + ", contentPropertyMap=" + this.contentPropertyMap + ", fieldNameContentPropertyMap=" + this.fieldNameContentPropertyMap + ", ignoreMap=" + this.ignoreMap + ", headNames=" + this.headNames + '}';
    }
}

