/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv;

import cn.com.yusys.yusp.commons.excelcsv.ITemplate;
import cn.com.yusys.yusp.commons.excelcsv.bill.Merge2Command;
import cn.com.yusys.yusp.commons.excelcsv.bill.XlsCommentAreaExtBuilder;
import cn.com.yusys.yusp.commons.excelcsv.handle.DataHandle;
import cn.com.yusys.yusp.commons.excelcsv.util.CommonFunctions;
import cn.com.yusys.yusp.commons.util.ReflectionUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Workbook;
import org.jxls.area.Area;
import org.jxls.builder.AreaBuilder;
import org.jxls.builder.xls.XlsCommentAreaBuilder;
import org.jxls.command.AbstractCommand;
import org.jxls.command.Command;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.common.Size;
import org.jxls.expression.JexlExpressionEvaluator;
import org.jxls.transform.Transformer;
import org.jxls.transform.poi.PoiContext;
import org.jxls.transform.poi.PoiTransformer;
import org.jxls.util.JxlsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BillTemplate
implements ITemplate {
    private static final Logger logger = LoggerFactory.getLogger(BillTemplate.class);
    private static final String SPECIAL_CHARS = "[`~!@#$%^&*()\\-=+{}':\\[\\].<>?,.\"\uff0c\u3002\u3001\uff1f\u3010\u3011|/]";
    private static final Pattern p = Pattern.compile("[`~!@#$%^&*()\\-=+{}':\\[\\].<>?,.\"\uff0c\u3002\u3001\uff1f\u3010\u3011|/]");
    private final byte[] templateBytes;
    private final DataHandle dataHandle;

    public BillTemplate(byte[] templateBytes, DataHandle dataHandle) {
        this.templateBytes = templateBytes;
        this.dataHandle = dataHandle;
    }

    public BillTemplate(File templateFile, DataHandle dataHandle) {
        try (FileInputStream is = new FileInputStream(templateFile);){
            this.templateBytes = IOUtils.toByteArray((InputStream)is);
        }
        catch (IOException e) {
            throw new IllegalStateException("read template failed.", e);
        }
        this.dataHandle = dataHandle;
    }

    private static String replaceSpecialChar(String str) {
        Matcher m = p.matcher(str);
        return m.replaceAll("");
    }

    @Override
    public void export(Object model, File outFile) {
        XlsCommentAreaBuilder.addCommandMapping((String)"cellKey", DetailAreaReportCommand.class);
        XlsCommentAreaBuilder.addCommandMapping((String)"merge2", Merge2Command.class);
        try (ByteArrayInputStream is = new ByteArrayInputStream(this.templateBytes);
             FileOutputStream os = new FileOutputStream(outFile);){
            PoiTransformer transformer = PoiTransformer.createTransformer((InputStream)is, (OutputStream)os);
            JexlExpressionEvaluator evaluator = (JexlExpressionEvaluator)transformer.getTransformationConfig().getExpressionEvaluator();
            HashMap<String, CommonFunctions> functionMap = new HashMap<String, CommonFunctions>(8);
            functionMap.put("func", new CommonFunctions(this.dataHandle));
            JexlEngine customJexlEngine = new JexlBuilder().namespaces(functionMap).create();
            evaluator.setJexlEngine(customJexlEngine);
            JxlsHelper.getInstance().setAreaBuilder((AreaBuilder)new XlsCommentAreaExtBuilder()).processTemplate((Context)new BillContext(model), (Transformer)transformer);
        }
        catch (IOException e) {
            if (outFile.exists()) {
                try {
                    FileUtils.forceDelete((File)outFile);
                }
                catch (IOException ex) {
                    logger.error("Delete temp file failed. Please delete manually. IOException messgage:{}", (Object)ex.getMessage());
                }
            }
            throw new IllegalStateException("export template error.", e);
        }
    }

    public static String keyFields2Key(Object obj, String keyFields) {
        try {
            String[] keyFieldArr = keyFields.split(",");
            StringBuilder keySb = new StringBuilder("KEY_");
            for (String keyField : keyFieldArr) {
                Object value = ReflectionUtils.getPropertyValue((Object)obj, (String)keyField);
                keySb.append(value == null ? "" : value.toString());
                keySb.append("_");
            }
            keySb.deleteCharAt(keySb.length() - 1);
            return BillTemplate.replaceSpecialChar(keySb.toString());
        }
        catch (Exception e) {
            throw new IllegalStateException("can not get field value", e);
        }
    }

    public static class DetailAreaReportCommand
    extends AbstractCommand {
        public static final String COMMAND_NAME = "cellKey";
        private Area area;
        private String var = null;
        private String keyFields = null;

        public String getName() {
            return COMMAND_NAME;
        }

        public Size applyAt(CellRef cellRef, Context context) {
            Objects.requireNonNull(this.var, "in command [jx:cellKey()], param [var] can not be null.");
            Objects.requireNonNull(this.keyFields, "in command [jx:cellKey()], param [keyFields] can not be null.");
            Size resultSize = this.area.applyAt(cellRef, context);
            if (resultSize.equals((Object)Size.ZERO_SIZE)) {
                return resultSize;
            }
            Workbook workbook = ((PoiTransformer)this.area.getTransformer()).getWorkbook();
            String targetSheetName = cellRef.getSheetName();
            String cellName = cellRef.getCellName().split("!")[1];
            String address = "'" + targetSheetName + "'!$" + cellName.replaceAll("\\d+", "") + "$" + (cellRef.getRow() + 1);
            Object obj = context.getVar(this.var);
            String key = BillTemplate.keyFields2Key(obj, this.keyFields);
            Name name = workbook.createName();
            name.setNameName(key);
            name.setRefersToFormula(address);
            return resultSize;
        }

        public Command addArea(Area area) {
            super.addArea(area);
            this.area = area;
            return this;
        }

        public void setVar(String var) {
            this.var = var;
        }

        public void setKeyFields(String keyFields) {
            this.keyFields = keyFields;
        }
    }

    static class BillContext
    extends PoiContext {
        public BillContext(Object model) {
            this.putVar("root", model);
        }
    }
}

