/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelpdf.utils;

import cn.com.yusys.yusp.commons.util.StringUtils;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.pdf.BaseFont;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FontUtils {
    private static final Logger log = LoggerFactory.getLogger(FontUtils.class);
    private static final Map<String, BaseFont> BASE_FONT_MAP = new ConcurrentHashMap<String, BaseFont>();
    private static BaseFont SONG_FONT_CHINESE;
    private static BaseFont EN_FONT;

    private FontUtils() {
    }

    public static BaseFont getSongFontChinese() {
        return SONG_FONT_CHINESE;
    }

    public static void registerBaseFont(String fontName, String fontFilePath, String encoding, boolean embedded) {
        try {
            BaseFont baseFont = BaseFont.createFont((String)fontFilePath, (String)encoding, (boolean)embedded);
            BASE_FONT_MAP.putIfAbsent(fontName, baseFont);
        }
        catch (DocumentException | IOException e) {
            throw new IllegalStateException("create base font " + fontName + "failed.", e);
        }
    }

    public static void registerBaseFont(String fontName, String fontFilePath) {
        FontUtils.registerBaseFont(fontName, fontFilePath, "Identity-H", false);
    }

    public static Font getFont(String fontName) {
        if (StringUtils.isBlank((CharSequence)fontName)) {
            return new Font(SONG_FONT_CHINESE, 8.0f, 0);
        }
        BaseFont baseFont = BASE_FONT_MAP.get(fontName);
        if (baseFont == null) {
            Font font = FontFactory.getFont((String)fontName, (String)"Identity-H");
            if (font != null && font.getBaseFont() != null) {
                return font;
            }
            log.debug("the font {} do not register. will use default STSongStd-Light font.", (Object)fontName);
            baseFont = SONG_FONT_CHINESE;
        }
        return new Font(baseFont, 8.0f, 0);
    }

    static {
        try {
            SONG_FONT_CHINESE = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            BASE_FONT_MAP.put("\u5b8b\u4f53", SONG_FONT_CHINESE);
            BASE_FONT_MAP.put("STSongStd-Light", SONG_FONT_CHINESE);
            EN_FONT = BaseFont.createFont((String)"Times-Roman", (String)"", (boolean)false);
            BASE_FONT_MAP.put("Times New Roman", EN_FONT);
            FontFactory.registerDirectories();
        }
        catch (Exception e) {
            log.error("create base font failed.", (Throwable)e);
        }
    }
}

