/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelpdf.transform;

import cn.com.yusys.yusp.commons.excelpdf.utils.DateUtils;
import cn.com.yusys.yusp.commons.excelpdf.utils.ExcelColorUtils;
import cn.com.yusys.yusp.commons.excelpdf.utils.FontUtils;
import cn.com.yusys.yusp.commons.excelpdf.utils.UnitConverterUtils;
import cn.com.yusys.yusp.commons.util.ArrayUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.apache.poi.hssf.usermodel.HSSFDataFormatter;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FontUnderline;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfCellHandler {
    private static final Logger log = LoggerFactory.getLogger(PdfCellHandler.class);
    private static final Locale DEFAULT_LOCAL = Locale.getDefault();
    private static final Locale LOCAL_ZH_CN = Locale.SIMPLIFIED_CHINESE;
    private static final Locale LOCAL_EN = Locale.US;
    private static final int[] DEFAULT_BACKGROUND_COLOR = new int[]{255, 255, 255, 255};
    private static final int[] DEFAULT_FONT_COLOR = new int[]{0, 0, 0, 255};
    private Workbook workbook;
    private Sheet sheet;
    private FormulaEvaluator evaluator;
    private float scale;
    private ExcelColorUtils excelColor;
    private CellStyle nullStyle;

    public PdfCellHandler(Workbook workbook, Sheet sheet, FormulaEvaluator evaluator, float scale) {
        this.workbook = workbook;
        this.sheet = sheet;
        this.evaluator = evaluator;
        this.scale = UnitConverterUtils.ptToPx(scale);
        this.excelColor = new ExcelColorUtils(this.workbook);
    }

    public PdfPCell get(Cell cell, int rowSpan, int colSpan) {
        int[] backgroundColor = this.excelColor.getFillForegroundColor(cell);
        backgroundColor = ArrayUtils.isEmpty((int[])backgroundColor) ? DEFAULT_BACKGROUND_COLOR : backgroundColor;
        PdfPCell pdfCell = new PdfPCell();
        pdfCell.setBackgroundColor(new BaseColor(backgroundColor[0], backgroundColor[1], backgroundColor[2], backgroundColor[3]));
        pdfCell.setRowspan(rowSpan);
        pdfCell.setColspan(colSpan);
        this.setCellContent(pdfCell, cell);
        this.setBorder(pdfCell, cell, this.excelColor);
        this.setCellSize(pdfCell, cell);
        return pdfCell;
    }

    private void setCellBackgroundColor(PdfPCell pdfCell, Cell cell) {
        int[] backgroundColor = this.excelColor.getFillForegroundColor(cell);
        backgroundColor = ArrayUtils.isEmpty((int[])backgroundColor) ? DEFAULT_BACKGROUND_COLOR : backgroundColor;
        pdfCell.setBackgroundColor(new BaseColor(backgroundColor[0], backgroundColor[1], backgroundColor[2], backgroundColor[3]));
    }

    private void setCellContent(PdfPCell pdfCell, Cell cell) {
        if (cell.getCellType() == CellType.STRING && cell.getStringCellValue().isEmpty()) {
            pdfCell.setPhrase(new Phrase(" "));
            return;
        }
        pdfCell.setVerticalAlignment(this.getVerticalAlignment(cell.getCellStyle().getVerticalAlignment()));
        pdfCell.setHorizontalAlignment(this.getHorizontalAlignment(cell.getCellStyle().getAlignment()));
        int[] fontColor = this.excelColor.getFontColor(cell);
        fontColor = ArrayUtils.isEmpty((int[])fontColor) ? DEFAULT_FONT_COLOR : fontColor;
        pdfCell.setPhrase(this.getContent(cell, fontColor));
    }

    private void setCellSize(PdfPCell pdfCell, Cell cell) {
        float excelCellHeight = cell.getRow().getHeightInPoints() * this.scale;
        float excelRowDefaultHeight = this.sheet.getDefaultRowHeightInPoints() * this.scale;
        float fontSize = pdfCell.getPhrase().getFont().getSize() * this.scale;
        float diff = 1.0E-6f;
        if (Math.abs(excelRowDefaultHeight - excelCellHeight) > diff && fontSize < excelCellHeight) {
            pdfCell.setMinimumHeight(excelCellHeight);
        }
        if (this.isEmptyCell(cell)) {
            pdfCell.setFixedHeight(excelCellHeight);
        }
    }

    private boolean isEmptyCell(Cell cell) {
        return cell.getCellType() == CellType.STRING && cell.getStringCellValue().isEmpty();
    }

    private int getVerticalAlignment(VerticalAlignment align) {
        switch (align) {
            case CENTER: {
                return 5;
            }
            case JUSTIFY: {
                return 3;
            }
            case TOP: {
                return 4;
            }
        }
        return 6;
    }

    private int getHorizontalAlignment(HorizontalAlignment align) {
        switch (align) {
            case RIGHT: {
                return 2;
            }
            case JUSTIFY: {
                return 3;
            }
            case CENTER: {
                return 1;
            }
        }
        return 0;
    }

    private Phrase getContent(Cell cell, int[] fontColor) {
        String cellStringValue = this.getContent(cell);
        if (this.nullStyle == null) {
            this.nullStyle = this.workbook.createCellStyle();
        }
        return new Phrase(cellStringValue, this.getFont(cell == null ? this.nullStyle : cell.getCellStyle(), fontColor));
    }

    private String getContent(Cell cell) {
        String cellStringValue;
        if (cell == null) {
            cellStringValue = "";
        } else {
            String dataFormatString = cell.getCellStyle().getDataFormatString();
            if (cell.getCellType() == CellType.STRING) {
                cellStringValue = cell.getStringCellValue();
            } else if (cell.getCellType() == CellType.NUMERIC) {
                short format = cell.getCellStyle().getDataFormat();
                cellStringValue = this.getNumericCellValue(cell, dataFormatString, format);
            } else if (cell.getCellType() == CellType.FORMULA) {
                HSSFDataFormatter df = new HSSFDataFormatter();
                cellStringValue = df.formatCellValue(cell, this.evaluator);
            } else {
                cellStringValue = cell.getStringCellValue();
            }
        }
        return cellStringValue;
    }

    private String getNumericCellValue(Cell cell, String dataFormatString, short format) {
        String cellStringValue;
        if (format == 55 || format == 56) {
            Date date = DateUtil.getJavaDate((double)cell.getNumericCellValue());
            LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            cellStringValue = DateTimeFormatter.ofPattern("HH:mm:ss").format(localDateTime);
        } else if (format == 57) {
            Date date = DateUtil.getJavaDate((double)cell.getNumericCellValue());
            LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            cellStringValue = DateTimeFormatter.ofPattern("yyyy-MM").format(localDate);
        } else if (format == 58) {
            Date date = DateUtil.getJavaDate((double)cell.getNumericCellValue());
            LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            cellStringValue = DateTimeFormatter.ofPattern("MM-dd").format(localDate);
        } else {
            Locale locale = DEFAULT_LOCAL;
            if (!StringUtils.isBlank((CharSequence)dataFormatString)) {
                if (dataFormatString.contains("[$-804]")) {
                    locale = LOCAL_ZH_CN;
                }
                if (dataFormatString.contains("[$-409]")) {
                    locale = LOCAL_EN;
                }
            }
            HSSFDataFormatter df = new HSSFDataFormatter(locale);
            cellStringValue = df.formatCellValue(cell);
            cellStringValue = this.replaceCellStringValue(cell, dataFormatString, cellStringValue);
        }
        return cellStringValue;
    }

    private String replaceCellStringValue(Cell cell, String dataFormatString, String cellStringValue) {
        if (DateUtils.isCellDateFormatted(cell)) {
            String reg = "^-?[0-9]+(.[0-9]+)?$";
            if (cellStringValue.matches(reg)) {
                cellStringValue = new SimpleDateFormat(dataFormatString.replace("h", "H")).format(DateUtil.getJavaDate((double)cell.getNumericCellValue()));
            }
            cellStringValue = cellStringValue.replace("\"\u5e74\"", "\u5e74").replace("\"\u6708\"", "\u6708").replace("\"\u65e5\"", "\u65e5").replace("\\", "").replace("\"\u65f6\"", "\u65f6").replace("\"\u5206\"", "\u5206").replace("\"\u79d2\"", "\u79d2").replace(";@", "");
        }
        if ("[DBNum1][$-804]h\"\u65f6\"mm\"\u5206\";@".equals(dataFormatString)) {
            cellStringValue = new SimpleDateFormat("HH\u65f6:mm\u5206").format(DateUtil.getJavaDate((double)cell.getNumericCellValue()));
        }
        return cellStringValue;
    }

    private Font getFont(CellStyle style, int[] fontColor) {
        String fontName = this.workbook.getFontAt(style.getFontIndexAsInt()).getFontName();
        Font pdfFont = FontUtils.getFont(fontName);
        int index = style.getFontIndexAsInt();
        org.apache.poi.ss.usermodel.Font font = this.workbook.getFontAt(index);
        pdfFont.setSize((float)font.getFontHeightInPoints() * this.scale);
        if (font.getBold()) {
            pdfFont.setStyle(Font.FontStyle.BOLD.getValue());
        }
        pdfFont.setColor(new BaseColor(fontColor[0], fontColor[1], fontColor[2], fontColor[3]));
        FontUnderline underline = FontUnderline.valueOf((byte)font.getUnderline());
        if (underline == FontUnderline.SINGLE || underline == FontUnderline.DOUBLE) {
            String ulString = Font.FontStyle.UNDERLINE.getValue();
            pdfFont.setStyle(ulString);
        }
        if (font.getItalic()) {
            pdfFont.setStyle(Font.FontStyle.ITALIC.getValue());
        }
        if (font.getStrikeout()) {
            pdfFont.setStyle(Font.FontStyle.LINETHROUGH.getValue());
        }
        return pdfFont;
    }

    public void setBorder(PdfPCell pdfCell, Cell cell, ExcelColorUtils excelColor) {
        int[] defaultColor = new int[]{0, 0, 0, 255};
        this.disableCellBorder(pdfCell, cell);
        int[] borderTop = excelColor.getTopBorderColor(cell);
        borderTop = borderTop == null || borderTop.length == 0 ? defaultColor : borderTop;
        int[] borderBottom = excelColor.getBottomBorderColor(cell);
        borderBottom = borderBottom == null || borderBottom.length == 0 ? defaultColor : borderBottom;
        int[] borderLeft = excelColor.getLeftBorderColor(cell);
        borderLeft = borderLeft == null || borderLeft.length == 0 ? defaultColor : borderLeft;
        int[] borderRight = excelColor.getRightBorderColor(cell);
        borderRight = borderRight == null || borderRight.length == 0 ? defaultColor : borderRight;
        pdfCell.setBorderColorTop(new BaseColor(borderTop[0], borderTop[1], borderTop[2], borderTop[3]));
        pdfCell.setBorderColorBottom(new BaseColor(borderBottom[0], borderBottom[1], borderBottom[2], borderBottom[3]));
        pdfCell.setBorderColorLeft(new BaseColor(borderLeft[0], borderLeft[1], borderLeft[2], borderLeft[3]));
        pdfCell.setBorderColorRight(new BaseColor(borderRight[0], borderRight[1], borderRight[2], borderRight[3]));
    }

    private void disableCellBorder(PdfPCell pdfCell, Cell startCell) {
        CellStyle style = startCell.getCellStyle();
        if (BorderStyle.NONE.equals((Object)style.getBorderTop())) {
            log.debug("\u884c:{},\u5217:{},{}:\u7981\u7528\u4e0a\u8fb9\u6846", new Object[]{startCell.getRowIndex(), startCell.getColumnIndex(), pdfCell.getPhrase().getContent()});
            pdfCell.disableBorderSide(1);
        }
        if (BorderStyle.NONE.equals((Object)style.getBorderLeft())) {
            log.debug("\u884c:{},\u5217:{},{}:\u7981\u7528\u5de6\u8fb9\u6846", new Object[]{startCell.getRowIndex(), startCell.getColumnIndex(), pdfCell.getPhrase().getContent()});
            pdfCell.disableBorderSide(4);
        }
        int rowsSpan = pdfCell.getRowspan();
        int colsSpan = pdfCell.getColspan();
        int endCol = startCell.getColumnIndex() + colsSpan - 1;
        int endRow = startCell.getRowIndex() + rowsSpan - 1;
        Cell endCell = this.sheet.getRow(endRow).getCell(endCol);
        if (Objects.isNull(endCell)) {
            log.warn("\u5408\u5e76\u5355\u5143\u683c:{},{}\u65e0\u6cd5\u83b7\u53d6.", (Object)endRow, (Object)endCol);
            return;
        }
        style = endCell.getCellStyle();
        if (BorderStyle.NONE.equals((Object)style.getBorderBottom())) {
            log.debug("\u884c:{},\u5217:{},{}:\u7981\u7528\u4e0b\u8fb9\u6846", new Object[]{endRow, endCol, pdfCell.getPhrase().getContent()});
            pdfCell.disableBorderSide(2);
        }
        if (BorderStyle.NONE.equals((Object)style.getBorderRight())) {
            log.debug("\u884c:{},\u5217:{},{}:\u7981\u7528\u53f3\u8fb9\u6846", new Object[]{endRow, endCol, pdfCell.getPhrase().getContent()});
            pdfCell.disableBorderSide(8);
        }
    }
}

