/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelpdf.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class Excel {
    private String anchorName;
    private File excelFile;
    private InputStream inputStream;
    private Workbook workbook;
    private List<Sheet> sheetList;

    public Excel(File excelFile) {
        this.excelFile = excelFile;
        this.initExcel();
    }

    public Excel(InputStream inputStream) {
        this.inputStream = inputStream;
        this.initExcel();
    }

    public Excel(String anchorName, File excelFile) {
        this.anchorName = anchorName;
        this.excelFile = excelFile;
        this.initExcel();
    }

    public Excel(String anchorName, InputStream inputStream) {
        this.anchorName = anchorName;
        this.inputStream = inputStream;
        this.initExcel();
    }

    private void initExcel() {
        if (this.inputStream == null && this.excelFile == null) {
            throw new IllegalStateException("the inputStream or file must be assigned");
        }
        try {
            if (this.inputStream == null) {
                this.inputStream = new FileInputStream(this.excelFile);
            }
            this.workbook = WorkbookFactory.create((InputStream)this.inputStream);
            int sheetTotal = this.workbook.getNumberOfSheets();
            this.sheetList = new ArrayList<Sheet>();
            for (int i = 0; i < sheetTotal; ++i) {
                this.sheetList.add(this.workbook.getSheetAt(i));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setAnchorName(String anchorName) {
        this.anchorName = anchorName;
    }

    public String getAnchorName() {
        return this.anchorName;
    }

    public File getExcelFile() {
        return this.excelFile;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public List<Sheet> getSheetList() {
        return this.sheetList;
    }
}

