/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelpdf.transform;

import cn.com.yusys.yusp.commons.excelpdf.metadata.Pdf;
import cn.com.yusys.yusp.commons.excelpdf.utils.FontUtils;
import com.itextpdf.text.Document;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;

public class PdfEvent
extends PdfPageEventHelper {
    private final Pdf pdf;
    protected PdfTemplate template;
    private BaseFont baseFont;

    public PdfEvent(Pdf pdf) {
        this.pdf = pdf;
    }

    public void onStartPage(PdfWriter writer, Document document) {
        try {
            this.template = writer.getDirectContent().createTemplate(100.0f, 100.0f);
            this.baseFont = new Font(FontUtils.getSongFontChinese(), 8.0f, 0).getBaseFont();
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public void onEndPage(PdfWriter writer, Document document) {
        float positionX;
        String header = this.pdf.getPageHeader();
        String footer = this.pdf.getPageFooter();
        if (header != null && !header.isEmpty()) {
            float headerWidth = this.baseFont.getWidthPoint(header, 8.0f);
            positionX = document.right() / 2.0f - headerWidth / 2.0f;
            this.writeExtraContent(writer, header, positionX, document.top() + 10.0f);
        }
        if (footer != null && !footer.isEmpty()) {
            float footerWidth = this.baseFont.getWidthPoint(footer, 8.0f);
            positionX = document.right() / 2.0f - footerWidth / 2.0f;
            this.writeExtraContent(writer, footer, positionX, document.bottom() - 10.0f);
        }
        if (this.pdf.isWithPageNum()) {
            int pageNum = writer.getPageNumber();
            float pageNumWidth = this.baseFont.getWidthPoint(String.valueOf(pageNum), 8.0f);
            float positionX2 = document.right() - pageNumWidth;
            this.writeExtraContent(writer, String.valueOf(pageNum), positionX2, document.bottom() - 10.0f);
        }
    }

    private void writeExtraContent(PdfWriter writer, String extraContent, float positionX, float positionY) {
        PdfContentByte byteContent = writer.getDirectContent();
        byteContent.beginText();
        byteContent.setFontAndSize(this.baseFont, 10.0f);
        byteContent.setTextMatrix(positionX, positionY);
        byteContent.showText(extraContent);
        byteContent.endText();
        byteContent.addTemplate(this.template, positionX, positionY);
    }
}

