/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelpdf.metadata;

import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class Pdf {
    private final File pdfFile;
    private final OutputStream outputStream;
    private final String password;
    private final Rectangle pageSize;
    private final boolean exportOnePage;
    private final boolean readOnly;
    private final String pageHeader;
    private final String pageFooter;
    private final float contentMarginTop;
    private final float contentMarginBottom;
    private final float contentMarginLeft;
    private final float contentMarginRight;
    private final boolean withPageNum;
    private final PdfDirection direction;

    public Pdf(PdfBuilder pdfBuilder) {
        this.pdfFile = pdfBuilder.pdfFile;
        this.outputStream = pdfBuilder.outputStream;
        this.password = pdfBuilder.password;
        this.pageSize = pdfBuilder.pageSize;
        this.readOnly = pdfBuilder.readOnly;
        this.exportOnePage = pdfBuilder.exportOnePage;
        this.pageHeader = pdfBuilder.pageHeader;
        this.pageFooter = pdfBuilder.pageFooter;
        this.contentMarginTop = pdfBuilder.contentMarginTop;
        this.contentMarginBottom = pdfBuilder.contentMarginBottom;
        this.contentMarginLeft = pdfBuilder.contentMarginLeft;
        this.contentMarginRight = pdfBuilder.contentMarginRight;
        this.withPageNum = pdfBuilder.withPageNum;
        this.direction = pdfBuilder.direction;
    }

    public File getPdfFile() {
        return this.pdfFile;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public String getPassword() {
        return this.password;
    }

    public Rectangle getPageSize() {
        return this.pageSize;
    }

    public boolean isExportOnePage() {
        return this.exportOnePage;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String getPageHeader() {
        return this.pageHeader;
    }

    public String getPageFooter() {
        return this.pageFooter;
    }

    public float getContentMarginTop() {
        return this.contentMarginTop;
    }

    public float getContentMarginBottom() {
        return this.contentMarginBottom;
    }

    public float getContentMarginLeft() {
        return this.contentMarginLeft;
    }

    public float getContentMarginRight() {
        return this.contentMarginRight;
    }

    public boolean isWithPageNum() {
        return this.withPageNum;
    }

    public PdfDirection getDirection() {
        return this.direction;
    }

    public static PdfBuilder builder() {
        return new PdfBuilder();
    }

    public static final class PdfBuilder {
        private File pdfFile;
        private OutputStream outputStream;
        private String password;
        private Rectangle pageSize = PageSize.A4;
        private boolean readOnly = Boolean.TRUE;
        private boolean exportOnePage;
        private String pageHeader;
        private String pageFooter;
        private float contentMarginTop = 36.0f;
        private float contentMarginLeft = 36.0f;
        private float contentMarginRight = 36.0f;
        private float contentMarginBottom = 36.0f;
        private boolean withPageNum;
        private PdfDirection direction = PdfDirection.VERTICAL;

        private PdfBuilder() {
        }

        public PdfBuilder pdfFile(File pdfFile) {
            this.pdfFile = pdfFile;
            return this;
        }

        public PdfBuilder outputStream(OutputStream outputStream) {
            this.outputStream = outputStream;
            return this;
        }

        public PdfBuilder password(String password) {
            this.password = password;
            return this;
        }

        public PdfBuilder pageSize(Rectangle pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public PdfBuilder readOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public PdfBuilder exportOnePage(boolean exportOnePage) {
            this.exportOnePage = exportOnePage;
            return this;
        }

        public PdfBuilder pageHeader(String pageHeader) {
            this.pageHeader = pageHeader;
            return this;
        }

        public PdfBuilder pageFooter(String pageFooter) {
            this.pageFooter = pageFooter;
            return this;
        }

        public PdfBuilder contentMarginTop(float contentMarginTop) {
            this.contentMarginTop = contentMarginTop;
            return this;
        }

        public PdfBuilder contentMarginBottom(float contentMarginBottom) {
            this.contentMarginBottom = contentMarginBottom;
            return this;
        }

        public PdfBuilder contentMarginLeft(float contentMarginLeft) {
            this.contentMarginLeft = contentMarginLeft;
            return this;
        }

        public PdfBuilder contentMarginRight(float contentMarginRight) {
            this.contentMarginRight = contentMarginRight;
            return this;
        }

        public PdfBuilder withPageNum(boolean withPageNum) {
            this.withPageNum = withPageNum;
            return this;
        }

        public PdfBuilder direction(PdfDirection direction) {
            this.direction = direction;
            return this;
        }

        public Pdf build() {
            if (this.pdfFile == null && this.outputStream == null) {
                throw new IllegalStateException("Must assign pdf file");
            }
            if (this.outputStream == null) {
                try {
                    this.outputStream = new FileOutputStream(this.pdfFile);
                }
                catch (FileNotFoundException e) {
                    throw new IllegalStateException("Can not get outputStream from pdf file, message:" + e.getMessage(), e);
                }
            }
            return new Pdf(this);
        }
    }

    public static enum PdfDirection {
        VERTICAL,
        HORIZONTAL;

    }
}

