/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelpdf.transform;

import cn.com.yusys.yusp.commons.excelpdf.metadata.Excel;
import cn.com.yusys.yusp.commons.excelpdf.metadata.Pdf;
import cn.com.yusys.yusp.commons.excelpdf.transform.PdfCellHandler;
import cn.com.yusys.yusp.commons.excelpdf.utils.UnitConverterUtils;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class Sheet2PTable {
    private final Excel excel;
    private final Pdf pdf;
    private Map<Sheet, Integer> maxColIndexMap = new HashMap<Sheet, Integer>();
    private Map<Sheet, Integer> sheetHeightMap = new HashMap<Sheet, Integer>();
    private Map<Sheet, Integer> sheetWidthMap = new HashMap<Sheet, Integer>();
    private int maxSheetHeight;
    private int maxSheetWidth;
    private Map<Sheet, float[]> colWidthArrayMap = new HashMap<Sheet, float[]>();
    private Map<Sheet, List<CellRangeAddress>> mergedRegionMap = new HashMap<Sheet, List<CellRangeAddress>>();
    private Workbook workbook;
    private FormulaEvaluator evaluator;
    private float scale;

    public Sheet2PTable(Excel excel, Pdf pdf) {
        this(excel, pdf, 1.0f);
    }

    public Sheet2PTable(Excel excel, Pdf pdf, float scale) {
        this.excel = excel;
        this.pdf = pdf;
        this.scale = scale;
        this.init();
    }

    public static CellRangeAddress isInRange(int rowIndex, int columnIndex, List<CellRangeAddress> mergedRegions) {
        for (CellRangeAddress mergedRegion : mergedRegions) {
            if (!mergedRegion.isInRange(rowIndex, columnIndex)) continue;
            return mergedRegion;
        }
        return null;
    }

    private void init() {
        this.workbook = this.excel.getWorkbook();
        this.evaluator = this.workbook.getCreationHelper().createFormulaEvaluator();
        for (Sheet sheet : this.excel.getSheetList()) {
            this.initParam(sheet);
        }
        this.maxSheetHeight = this.max(this.sheetHeightMap, "can not get sheet height");
        this.maxSheetWidth = this.max(this.sheetWidthMap, "can not get sheet width");
    }

    private int max(Map<Sheet, Integer> sheetMap, String errorMessage) {
        return (Integer)sheetMap.entrySet().stream().max(Map.Entry.comparingByValue()).orElseThrow(() -> new IllegalStateException(errorMessage)).getValue();
    }

    public void initParam(Sheet sheet) {
        int i;
        int maxColIndex = 0;
        int sheetWidth = 0;
        int sheetHeight = 0;
        int rowTotal = sheet.getLastRowNum();
        for (i = 0; i <= rowTotal; ++i) {
            Row row = sheet.getRow(i);
            maxColIndex = Math.max(maxColIndex, Objects.isNull(row) ? -1 : (int)row.getLastCellNum());
            sheetHeight = Objects.isNull(row) ? (int)((float)sheetHeight + UnitConverterUtils.ptToPx(sheet.getDefaultRowHeightInPoints())) : (int)((float)sheetHeight + UnitConverterUtils.ptToPx(row.getHeightInPoints()));
        }
        for (i = 0; i < maxColIndex; ++i) {
            sheetWidth = (int)((float)sheetWidth + sheet.getColumnWidthInPixels(i));
        }
        this.maxColIndexMap.put(sheet, maxColIndex);
        this.sheetHeightMap.put(sheet, sheetHeight);
        this.sheetWidthMap.putIfAbsent(sheet, sheetWidth);
        this.calcColWidth(sheet, maxColIndex);
        this.initMergedRegions(sheet);
    }

    private void calcColWidth(Sheet sheet, int maxColIndex) {
        float[] colWidthArray = new float[maxColIndex];
        for (int i = 0; i < maxColIndex; ++i) {
            colWidthArray[i] = sheet.getColumnWidthInPixels(i) * this.scale;
        }
        this.colWidthArrayMap.put(sheet, colWidthArray);
    }

    public void initMergedRegions(Sheet sheet) {
        int totalMergedRegionsNum = sheet.getNumMergedRegions();
        ArrayList<CellRangeAddress> mergedRegions = new ArrayList<CellRangeAddress>();
        for (int i = 0; i < totalMergedRegionsNum; ++i) {
            mergedRegions.add(sheet.getMergedRegion(i));
        }
        this.mergedRegionMap.put(sheet, mergedRegions);
    }

    public PdfPTable convertSheetToPdfTable(Sheet sheet, float pdfWidth, float pdfHeight) {
        float heightScale = 1.0f;
        heightScale = this.calcHeight(sheet, pdfWidth, pdfHeight, heightScale);
        PdfCellHandler pdfCellHandler = new PdfCellHandler(this.workbook, sheet, this.evaluator, heightScale);
        List<CellRangeAddress> mergedRegions = this.mergedRegionMap.get(sheet);
        int maxColNum = this.maxColIndexMap.get(sheet);
        int rowTotal = sheet.getLastRowNum();
        ArrayList<PdfPCell> cellList = new ArrayList<PdfPCell>();
        for (int rowIndex = 0; rowIndex <= rowTotal; ++rowIndex) {
            Row row = sheet.getRow(rowIndex);
            if (Objects.isNull(row)) {
                row = sheet.createRow(rowIndex);
            }
            for (int colIndex = 0; colIndex < maxColNum; ++colIndex) {
                colIndex = this.convertCell(pdfCellHandler, mergedRegions, cellList, rowIndex, row, colIndex);
            }
        }
        return this.createPdfTable(sheet, cellList);
    }

    private int convertCell(PdfCellHandler pdfCellHandler, List<CellRangeAddress> mergedRegions, List<PdfPCell> cellList, int rowIndex, Row row, int colIndex) {
        Cell cell = row.getCell(colIndex);
        if (this.skipCreateCell(mergedRegions, rowIndex, colIndex)) {
            return colIndex;
        }
        cell = this.formatCell(cell, row, colIndex);
        return this.createCell(pdfCellHandler, mergedRegions, cellList, rowIndex, colIndex, cell);
    }

    private boolean skipCreateCell(List<CellRangeAddress> mergedRegions, int rowIndex, int colIndex) {
        CellRangeAddress rangeAddress = Sheet2PTable.isInRange(rowIndex, colIndex, mergedRegions);
        return Objects.nonNull(rangeAddress) && Objects.nonNull(rangeAddress.getFirstRow()) && (rowIndex != rangeAddress.getFirstRow() || colIndex != rangeAddress.getFirstColumn());
    }

    private int createCell(PdfCellHandler pdfCellHandler, List<CellRangeAddress> mergedRegions, List<PdfPCell> cellList, int rowIndex, int colIndex, Cell cell) {
        colIndex = this.addPdfCell(pdfCellHandler, mergedRegions, cellList, rowIndex, colIndex, cell);
        return colIndex;
    }

    private float calcHeight(Sheet sheet, float pdfWidth, float pdfHeight, float heightScale) {
        float cellScale = heightScale;
        if ((float)this.maxSheetWidth > pdfWidth) {
            float widthScale;
            this.scale = widthScale = pdfWidth / (float)this.maxSheetWidth;
            cellScale = widthScale;
            this.calcColWidth(sheet, this.maxColIndexMap.get(sheet));
        }
        if (this.pdf.isExportOnePage() && (float)this.maxSheetHeight > pdfHeight) {
            heightScale = pdfHeight / (float)this.maxSheetHeight;
            cellScale = Math.min(heightScale, cellScale);
        }
        return cellScale;
    }

    private Cell formatCell(Cell cell, Row row, int colIndex) {
        if (Objects.isNull(cell)) {
            cell = row.createCell(colIndex, CellType.STRING);
            cell.setCellValue("");
        }
        if (cell.getCellType() != CellType.FORMULA && cell.getCellType() != CellType.NUMERIC) {
            cell.setCellType(CellType.STRING);
        }
        return cell;
    }

    private PdfPTable createPdfTable(Sheet sheet, List<PdfPCell> cellList) {
        PdfPTable table = new PdfPTable(this.colWidthArrayMap.get(sheet));
        table.setTotalWidth((float)this.maxSheetWidth * this.scale);
        table.setLockedWidth(true);
        table.setWidthPercentage(100.0f);
        for (PdfPCell pdfpCell : cellList) {
            table.addCell(pdfpCell);
        }
        return table;
    }

    private int addPdfCell(PdfCellHandler pdfCellHandler, List<CellRangeAddress> mergedRegions, List<PdfPCell> cellList, int rowIndex, int colIndex, Cell cell) {
        CellRangeAddress rangeAddress = Sheet2PTable.isInRange(rowIndex, colIndex, mergedRegions);
        int rowspan = 1;
        int colspan = 1;
        if (rangeAddress != null) {
            rowspan = rangeAddress.getLastRow() - rangeAddress.getFirstRow() + 1;
            colspan = rangeAddress.getLastColumn() - rangeAddress.getFirstColumn() + 1;
        }
        PdfPCell pdfpCell = pdfCellHandler.get(cell, rowspan, colspan);
        cellList.add(pdfpCell);
        return colIndex += colspan - 1;
    }

    public int getMaxSheetHeight() {
        return this.maxSheetHeight;
    }

    public int getMaxSheetWidth() {
        return this.maxSheetWidth;
    }
}

