/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelpdf;

import cn.com.yusys.yusp.commons.excelpdf.PdfWaterMarker;
import cn.com.yusys.yusp.commons.excelpdf.metadata.Excel;
import cn.com.yusys.yusp.commons.excelpdf.metadata.Pdf;
import cn.com.yusys.yusp.commons.excelpdf.metadata.WaterMarker;
import cn.com.yusys.yusp.commons.excelpdf.transform.TransformerITextImpl;
import com.itextpdf.text.PageSize;
import java.io.File;

public class ExcelToPdf {
    private static final String ERROR_DESC = "convert excel to pdf error.";
    private static final String PDF_PRE = "excel-to-pdf-";

    private ExcelToPdf() {
    }

    public static File convert(String excelPath) {
        File excelFile = new File(excelPath);
        return ExcelToPdf.convert(excelFile);
    }

    public static File convert(File excelFile) {
        return ExcelToPdf.convert(excelFile, 1.0f);
    }

    public static File convert(File excelFile, float scale) {
        try {
            File pdfFile = File.createTempFile(PDF_PRE, ".pdf");
            Pdf pdf = Pdf.builder().pdfFile(pdfFile).build();
            return ExcelToPdf.convert(excelFile, pdf, scale);
        }
        catch (Exception e) {
            throw new IllegalStateException(ERROR_DESC, e);
        }
    }

    public static File convert(File excelFile, Pdf pdf, float scale) {
        if (!excelFile.exists()) {
            throw new IllegalArgumentException("the excel file is not exists.");
        }
        Excel excel = new Excel(excelFile);
        try {
            TransformerITextImpl transformer = new TransformerITextImpl(pdf, excel, scale);
            transformer.transform();
            return pdf.getPdfFile();
        }
        catch (Exception e) {
            throw new IllegalStateException(ERROR_DESC, e);
        }
    }

    public static File convertWithA4(File excelFile, Pdf.PdfDirection direction, WaterMarker waterMarker) {
        try {
            File pdfFile = ExcelToPdf.convertWithA4(excelFile, direction);
            File outFile = File.createTempFile(PDF_PRE, ".pdf");
            PdfWaterMarker.markImgToPdf(pdfFile.getAbsolutePath(), outFile, null, waterMarker);
            return outFile;
        }
        catch (Exception e) {
            throw new IllegalStateException(ERROR_DESC, e);
        }
    }

    public static File convertWithA4(File excelFile, Pdf.PdfDirection direction) {
        try {
            File pdfFile = File.createTempFile(PDF_PRE, ".pdf");
            Pdf pdf = Pdf.builder().pageSize(PageSize.A4).direction(direction == null ? Pdf.PdfDirection.HORIZONTAL : direction).pdfFile(pdfFile).build();
            return ExcelToPdf.convert(excelFile, pdf, 1.0f);
        }
        catch (Exception e) {
            throw new IllegalStateException(ERROR_DESC, e);
        }
    }

    public static File convert(String excelPath, String imgPath) {
        return ExcelToPdf.convert(excelPath, new File(imgPath));
    }

    public static File convert(String excelPath, File imgFile) {
        return ExcelToPdf.convert(new File(excelPath), imgFile);
    }

    public static File convert(File excelFile, String imgPath) {
        return ExcelToPdf.convert(excelFile, new File(imgPath));
    }

    public static File convert(File excelFile, File imgFile) {
        WaterMarker waterMarker = new WaterMarker.MarkerBuilder().file(imgFile).build();
        return ExcelToPdf.convert(excelFile, waterMarker);
    }

    public static File convert(String excelPath, WaterMarker waterMarker) {
        return ExcelToPdf.convert(new File(excelPath), waterMarker);
    }

    public static File convert(File excelFile, WaterMarker waterMarker) {
        try {
            File pdfFile = ExcelToPdf.convert(excelFile, 1.0f);
            File outFile = File.createTempFile(PDF_PRE, ".pdf");
            PdfWaterMarker.markImgToPdf(pdfFile.getAbsolutePath(), outFile, null, waterMarker);
            return outFile;
        }
        catch (Exception e) {
            throw new IllegalStateException("can not convert excel to pdf with water marker.");
        }
    }
}

