/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.distributed.lock.impl;

import cn.com.yusys.yusp.commons.distributed.lock.Lock;
import cn.com.yusys.yusp.commons.distributed.lock.LockUtils;
import cn.com.yusys.yusp.commons.distributed.lock.impl.DistributedLock;
import cn.com.yusys.yusp.commons.distributed.lock.impl.ReentrantLock;
import cn.com.yusys.yusp.commons.exception.PlatformException;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

public class LockImpl
implements Lock {
    private static final Logger log = LoggerFactory.getLogger(LockImpl.class);
    private static final String ROOT_PATH_LOCK = "distributed-lock";
    Map<String, ReentrantLock> locks = new ConcurrentHashMap<String, ReentrantLock>();
    private final DistributedLock distributedLock;
    private final Object lockObj = new Object();

    public LockImpl(DistributedLock distributedLock) {
        this.distributedLock = distributedLock;
    }

    @Scheduled(fixedRate=1000L)
    public void cleanLocks() {
        Iterator<String> its = this.locks.keySet().iterator();
        LocalDateTime now = LocalDateTime.now();
        while (its.hasNext()) {
            String key = its.next();
            ReentrantLock value = this.locks.get(key);
            if (value.getCreateTime().plusMinutes(10L).compareTo(now) >= 0) continue;
            its.remove();
        }
    }

    @Override
    public boolean tryLock(String key, String group) {
        String realKey = this.getRealKey(key, group);
        ReentrantLock lock = this.createMemoryLock(realKey);
        boolean result = lock.tryLock();
        if (result) {
            int lockNum = lock.getLockState();
            log.info("lock key:{}, num:{}", (Object)realKey, (Object)lockNum);
            if (1 == lockNum) {
                try {
                    if (!this.distributedLock.tryLock(realKey)) {
                        lock.unlock();
                        result = false;
                    } else {
                        lock.addThreadId(LockUtils.getThreadId());
                        result = true;
                    }
                }
                catch (Exception e) {
                    log.error("lock key failed:{}", (Object)realKey);
                    lock.unlock();
                    result = false;
                }
            }
        }
        return result;
    }

    @Override
    public void lock(String key, String group, long blockTime) throws InterruptedException {
        String realKey = this.getRealKey(key, group);
        ReentrantLock lock = this.createMemoryLock(realKey);
        lock.lock();
        lock.addThreadId(LockUtils.getThreadId());
        int lockNum = lock.getLockState();
        log.info("lock key:{}, num:{}", (Object)realKey, (Object)lockNum);
        if (1 == lockNum) {
            try {
                this.distributedLock.lock(realKey, blockTime);
            }
            catch (Exception e) {
                log.error("lock key failed:{}", (Object)realKey, (Object)e);
                lock.unlock();
                throw new InterruptedException("lock failed," + e.getMessage());
            }
        }
    }

    @Override
    public void unlock(String key, String group) {
        String realKey = this.getRealKey(key, group);
        ReentrantLock lock = this.getMemoryLock(realKey);
        lock.getThreadIds().remove(LockUtils.getThreadId());
        int lockNum = lock.getLockState();
        if (1 == lockNum && lock.getThreadIds().isEmpty()) {
            try {
                this.distributedLock.unlock(realKey);
            }
            catch (Exception e) {
                log.error("Lock key:{} group:{} release distributed lock occur exception! cause by:{}", new Object[]{key, group, e.getMessage()});
            }
        }
        lock.unlock();
    }

    private void checkKey(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw new PlatformException("lock key must not null");
        }
        if (key.contains("/")) {
            throw new PlatformException("lock key must not contains /");
        }
    }

    private String getRealKey(String key, String group) {
        this.checkKey(key);
        this.checkKey(group);
        return "/distributed-lock/" + group + "/" + key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantLock createMemoryLock(String realKey) {
        Object object = this.lockObj;
        synchronized (object) {
            if (!this.locks.containsKey(realKey)) {
                this.locks.putIfAbsent(realKey, new ReentrantLock());
            }
            ReentrantLock lockInfo = this.locks.get(realKey);
            lockInfo.setCreateTime(LocalDateTime.now());
            return lockInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantLock getMemoryLock(String realKey) {
        Object object = this.lockObj;
        synchronized (object) {
            return this.locks.get(realKey);
        }
    }
}

