/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.distributed.lock.impl;

import cn.com.yusys.yusp.commons.distributed.lock.LockUtils;
import cn.com.yusys.yusp.commons.distributed.lock.impl.DistributedLock;
import cn.com.yusys.yusp.commons.exception.PlatformException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperDistributedLock
implements DistributedLock {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperDistributedLock.class);
    private final CuratorFramework zookeeperClient;

    public ZookeeperDistributedLock(CuratorFramework zookeeperClient) {
        this.zookeeperClient = zookeeperClient;
    }

    @Override
    public boolean tryLock(String key) {
        String pid = LockUtils.getThreadId();
        String nodeData = this.getNodeData(key);
        if (null != nodeData) {
            return nodeData.equals(pid);
        }
        try {
            ((ACLBackgroundPathAndBytesable)this.zookeeperClient.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(key, pid.getBytes());
            log.info("success to lock for path:{}", (Object)key);
            return true;
        }
        catch (KeeperException.NodeExistsException e) {
            log.info("NodeExists,failed to lock for path:{}", (Object)key);
            return false;
        }
        catch (Exception e) {
            log.error("failed to lock " + key, (Throwable)e);
            throw new PlatformException(String.format("failed to lock,key: %s", key), (Throwable)e);
        }
    }

    @Override
    public void unlock(String key) {
        try {
            ((ChildrenDeletable)this.zookeeperClient.delete().guaranteed()).deletingChildrenIfNeeded().forPath(key);
            log.info("success to unlock for path:{}", (Object)key);
        }
        catch (KeeperException.NoNodeException e) {
            log.info("success to unlock for path:{}", (Object)key);
        }
        catch (Exception e) {
            log.error("failed to unlock " + key, (Throwable)e);
            throw new PlatformException(String.format("failed to unlock %s", key), (Throwable)e);
        }
    }

    @Override
    public void lock(String key, long blockTime) {
        throw new PlatformException("zk lock does not support lock method.");
    }

    private String getNodeData(String keyPath) {
        block5: {
            try {
                Stat bb = (Stat)this.zookeeperClient.checkExists().forPath(keyPath);
                if (null != bb) {
                    byte[] pid = (byte[])this.zookeeperClient.getData().forPath(keyPath);
                    if (null != pid) {
                        return new String(pid);
                    }
                    break block5;
                }
                return null;
            }
            catch (KeeperException.NodeExistsException e) {
                log.warn("NodeExists,failed to getNodeData for path:{}", (Object)keyPath);
                return null;
            }
            catch (Exception e) {
                throw new PlatformException(String.format("failed to getZKNodeData for %s", keyPath), (Throwable)e);
            }
        }
        return null;
    }
}

