/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.distributed.lock.impl.db.service;

import cn.com.yusys.yusp.commons.distributed.lock.impl.db.domain.LockInfo;
import cn.com.yusys.yusp.commons.distributed.lock.impl.db.mapper.LockInfoMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class LockInfoService {
    private static final Logger log = LoggerFactory.getLogger(LockInfoService.class);
    private final LockInfoMapper lockInfoMapper;

    public LockInfoService(LockInfoMapper lockInfoMapper) {
        this.lockInfoMapper = lockInfoMapper;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public int deleteByPrimaryKey(String lockId) {
        return this.lockInfoMapper.deleteByPrimaryKey(lockId);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public int insertSelective(LockInfo record) {
        return this.lockInfoMapper.insertSelective(record);
    }

    public int insertSelectiveT(LockInfo record) {
        return this.lockInfoMapper.insertSelective(record);
    }

    public LockInfo selectByPrimaryKey(String lockId) {
        return this.lockInfoMapper.selectByPrimaryKey(lockId);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public int updateCreateTimeCas(LockInfo record) {
        return this.lockInfoMapper.updateCreateTimeCas(record);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void selectByPrimaryKeyForUpdate(String lockId, long time, String threadName) {
        try {
            LockInfo lockInfo = new LockInfo();
            lockInfo.setCreateTime(System.currentTimeMillis() + "");
            lockInfo.setLockId(lockId);
            lockInfo.setThreadName(threadName);
            this.insertSelectiveT(lockInfo);
            if (log.isDebugEnabled()) {
                log.debug("start to lock for path:{}", (Object)lockId);
            }
        }
        catch (DuplicateKeyException e) {
            if (log.isDebugEnabled()) {
                log.debug("data have Exists,start to lock for path:{}", (Object)lockId);
            }
        }
        catch (DataIntegrityViolationException e) {
            if (log.isDebugEnabled()) {
                log.debug("data have Exists,start to lock for path:{}", (Object)lockId);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("failed to lock " + lockId, e);
        }
        this.lockInfoMapper.selectByPrimaryKeyForUpdate(lockId, time);
    }
}

