/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.distributed.lock.impl;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

final class ReentrantLock
implements Lock,
Serializable {
    private static final long serialVersionUID = 7373984872572414689L;
    private final NonfairSync sync;
    private Set<String> threadIds = new CopyOnWriteArraySet<String>();
    private LocalDateTime createTime;

    public Set<String> getThreadIds() {
        return this.threadIds;
    }

    public void addThreadId(String threadId) {
        this.threadIds.add(threadId);
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public ReentrantLock() {
        this.sync = new NonfairSync();
    }

    @Override
    public void lock() {
        this.sync.lock();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.sync.acquireInterruptibly(1);
    }

    @Override
    public boolean tryLock() {
        return this.sync.tryAcquire(1);
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireNanos(1, unit.toNanos(timeout));
    }

    @Override
    public void unlock() {
        this.sync.release(1);
    }

    public int getLockState() {
        return this.sync.getLockState();
    }

    @Override
    public Condition newCondition() {
        return this.sync.newCondition();
    }

    public String toString() {
        Thread o = this.sync.getOwner();
        return super.toString() + (o == null ? "[Unlocked]" : "[Locked by thread " + o.getName() + "]");
    }

    static final class NonfairSync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = -5179523762034025860L;

        NonfairSync() {
        }

        final void lock() {
            if (this.compareAndSetState(0, 1)) {
                this.setExclusiveOwnerThread(Thread.currentThread());
            } else {
                this.acquire(1);
            }
        }

        final int getLockState() {
            return this.getState();
        }

        @Override
        protected final boolean tryAcquire(int acquires) {
            Thread current = Thread.currentThread();
            int c = this.getState();
            if (c == 0) {
                if (this.compareAndSetState(0, acquires)) {
                    this.setExclusiveOwnerThread(current);
                    return true;
                }
            } else if (current == this.getExclusiveOwnerThread()) {
                int nextc = c + acquires;
                if (nextc < 0) {
                    throw new Error("Maximum lock count exceeded");
                }
                this.setState(nextc);
                return true;
            }
            return false;
        }

        @Override
        protected final boolean tryRelease(int releases) {
            int c = this.getState() - releases;
            if (Thread.currentThread() != this.getExclusiveOwnerThread()) {
                throw new IllegalMonitorStateException();
            }
            boolean free = false;
            if (c == 0) {
                free = true;
                this.setExclusiveOwnerThread(null);
            }
            this.setState(c);
            return free;
        }

        @Override
        protected final boolean isHeldExclusively() {
            return this.getExclusiveOwnerThread() == Thread.currentThread();
        }

        final AbstractQueuedSynchronizer.ConditionObject newCondition() {
            return new AbstractQueuedSynchronizer.ConditionObject(this);
        }

        final Thread getOwner() {
            return this.getState() == 0 ? null : this.getExclusiveOwnerThread();
        }
    }
}

