/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.datasync.server.service;

import cn.com.yusys.yusp.commons.datasync.commons.SyncData;
import cn.com.yusys.yusp.commons.datasync.server.SyncDataService;
import cn.com.yusys.yusp.commons.datasync.server.SyncDataStore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;

public class SyncDataServiceImpl
implements SyncDataService {
    private static final Logger log = LoggerFactory.getLogger(SyncDataServiceImpl.class);
    private final Map<String, List<String>> tableSchemas = new HashMap<String, List<String>>();
    private final SyncDataStore syncDataStore;

    public SyncDataServiceImpl(SyncDataStore syncDataStore) {
        this.syncDataStore = syncDataStore;
    }

    public void addTableSchemas(Map<String, List<String>> tableSchemas) {
        this.tableSchemas.putAll(tableSchemas);
    }

    @Override
    public void handle(SyncData syncData) {
        String table = syncData.getTable();
        log.debug("Domain:{} ,table :{} data change.trigger sync.", (Object)syncData.getDomain(), (Object)table);
        if (this.tableSchemas.containsKey(table)) {
            List<String> schemas = this.tableSchemas.get(table);
            log.debug("table :{},schema:{} exec data sync.", (Object)table, schemas);
            schemas.forEach(schema -> {
                try {
                    this.syncDataStore.store(syncData, (String)schema);
                }
                catch (Exception e) {
                    log.warn("table :{},schema:{} exec data sync failed. cause by:{}", new Object[]{table, schema, e.getMessage()});
                }
            });
        }
    }

    @Override
    public void exceptionHandle(Throwable ex, Message<?> message) {
        log.debug("Message consumer failure, reject message.");
    }

    @Override
    public void competeHandle() {
        log.debug("Message consumer compete.");
    }
}

