/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.datasync.server.config;

import cn.com.yusys.yusp.commons.datasync.server.DataSyncServerConfig;
import cn.com.yusys.yusp.commons.datasync.server.DataSyncServerMessageChannel;
import cn.com.yusys.yusp.commons.datasync.server.SyncDataListener;
import cn.com.yusys.yusp.commons.datasync.server.SyncDataService;
import cn.com.yusys.yusp.commons.datasync.server.SyncDataStore;
import cn.com.yusys.yusp.commons.datasync.server.SyncTable;
import cn.com.yusys.yusp.commons.datasync.server.service.SyncDataServiceImpl;
import cn.com.yusys.yusp.commons.datasync.server.service.SyncDataWithoutRouteServiceImpl;
import cn.com.yusys.yusp.commons.datasync.server.store.JdbcTemplateSyncDataStore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
@ConditionalOnClass(value={Binder.class})
@ConditionalOnProperty(value={"yusp.data-sync.server.enabled"}, havingValue="true", matchIfMissing=true)
@EnableBinding(value={DataSyncServerMessageChannel.class})
public class DataSyncServerAutoConfiguration {
    public static final String DATASYNC_SERVER_PREFIX = "yusp.data-sync.server";
    public static final String DATASYNC_SERVER_ENABLED = "yusp.data-sync.server.enabled";
    @Value(value="${spring.shardingsphere.enabled:true}")
    public boolean NEED_ROUTE;

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="yusp.data-sync.server")
    public DataSyncServerConfig dataSyncServerConfig() {
        return new DataSyncServerConfig();
    }

    @Bean
    @ConditionalOnMissingBean
    public SyncDataStore syncDataStore(JdbcTemplate jdbcTemplate) {
        return new JdbcTemplateSyncDataStore(jdbcTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public SyncDataService syncDataService(SyncDataStore syncDataStore, DataSyncServerConfig serverConfig, Environment environment) {
        if (this.NEED_ROUTE) {
            Map<String, SyncTable> tables = serverConfig.getTables();
            HashMap<String, List<String>> tabDbs = new HashMap<String, List<String>>();
            tables.forEach((table, config) -> tabDbs.put((String)table, config.getTargets()));
            SyncDataServiceImpl syncDataService = new SyncDataServiceImpl(syncDataStore);
            syncDataService.addTableSchemas(tabDbs);
            return syncDataService;
        }
        SyncDataWithoutRouteServiceImpl syncDataService = new SyncDataWithoutRouteServiceImpl(syncDataStore);
        return syncDataService;
    }

    @Bean
    @ConditionalOnMissingBean
    public SyncDataListener syncDataListener(SyncDataService syncDataService) {
        return new SyncDataListener(syncDataService);
    }
}

