/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.datasync.server;

import cn.com.yusys.yusp.commons.datasync.commons.SyncData;
import cn.com.yusys.yusp.commons.datasync.commons.util.KryoUtils;
import cn.com.yusys.yusp.commons.datasync.server.SyncDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.messaging.Message;

public class SyncDataListener {
    private final Logger log = LoggerFactory.getLogger(SyncDataListener.class);
    private final SyncDataService syncDataService;

    public SyncDataListener(SyncDataService syncDataService) {
        this.syncDataService = syncDataService;
    }

    @StreamListener(value="data-sync-in")
    public void handleTableChange(Message<String> message) {
        this.log.debug("store message and ack.");
        this.log.debug("handleMessage.");
        try {
            String data = (String)message.getPayload();
            this.syncDataService.handle((SyncData)KryoUtils.readFormString((String)data));
        }
        catch (Exception e) {
            this.log.error("consumer failure.", (Throwable)e);
            this.syncDataService.exceptionHandle(e, message);
        }
        finally {
            this.syncDataService.competeHandle();
        }
    }
}

