/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.datasync.commons.config;

import cn.com.yusys.yusp.commons.datasync.commons.message.DataSyncEventStrategy;
import cn.com.yusys.yusp.commons.message.config.event.MessageEventAutoConfiguration;
import cn.com.yusys.yusp.commons.message.config.event.MessageEventProperties;
import cn.com.yusys.yusp.commons.message.rule.MessageEventStrategy;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@ConditionalOnClass(value={MessageEventStrategy.class})
@EnableConfigurationProperties(value={MessageEventProperties.class, BindingServiceProperties.class})
@AutoConfigureBefore(value={MessageEventAutoConfiguration.class})
public class DataSyncCommonsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MessageEventStrategy dataSyncEventStrategy(MessageEventProperties messageEventProperties, BindingServiceProperties bindingServiceProperties) {
        return new DataSyncEventStrategy(messageEventProperties.getMemory(), bindingServiceProperties);
    }

    static class DataSyncEnvironmentPostProcessor
    implements EnvironmentPostProcessor {
        private static final Logger log = LoggerFactory.getLogger(DataSyncEnvironmentPostProcessor.class);
        String dataSyncRouteKeyValue = "headers.eventName";

        DataSyncEnvironmentPostProcessor() {
        }

        public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
            HashMap<String, Object> messageMapping;
            MapPropertySource propertySource;
            boolean exists = environment.getPropertySources().contains("YuMessagePropertySources");
            if (exists) {
                propertySource = (MapPropertySource)environment.getPropertySources().get("YuMessagePropertySources");
                messageMapping = (Map)propertySource.getSource();
            } else {
                messageMapping = new HashMap();
                propertySource = new MapPropertySource("YuMessagePropertySources", messageMapping);
            }
            String dataSyncRouteKeyProperty = "spring.cloud.stream.rabbit.bindings.data-sync-out.producer.routingKeyExpression";
            String dataSyncBindKeyProperty = "spring.cloud.stream.rabbit.bindings.data-sync-in.consumer.bindingRoutingKey";
            String dataSyncDestinationProperty = "spring.cloud.stream.bindings.data-sync-in.destination";
            log.debug("set data sync message channel producer env.");
            this.putIfAbsent((Environment)environment, messageMapping, dataSyncRouteKeyProperty, this.dataSyncRouteKeyValue);
            log.debug("set data sync message channel consumer env.");
            this.putIfAbsent((Environment)environment, messageMapping, dataSyncBindKeyProperty, "*.*");
            this.putIfAbsent((Environment)environment, messageMapping, dataSyncDestinationProperty, "yusp-data-sync");
            if (!exists) {
                log.debug("Add Custom global message properties:{}", messageMapping);
                environment.getPropertySources().addLast((PropertySource)propertySource);
            }
        }

        void putIfAbsent(Environment environment, Map<String, Object> config, String key, Object value) {
            if (!environment.containsProperty(key)) {
                config.put(key, value);
            }
        }
    }
}

