/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.datasync.client.send;

import cn.com.yusys.yusp.commons.datasync.client.SyncDataSender;
import cn.com.yusys.yusp.commons.datasync.commons.SyncData;
import cn.com.yusys.yusp.commons.datasync.commons.message.DataSyncOut;
import cn.com.yusys.yusp.commons.datasync.commons.util.KryoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.integration.support.MessageBuilder;

@EnableBinding(value={DataSyncOut.class})
public class MessageSyncDataSender
implements SyncDataSender {
    private static final Logger log = LoggerFactory.getLogger(MessageSyncDataSender.class);
    @Autowired(required=false)
    DataSyncOut dataSyncOut;

    @Override
    public void send(SyncData data) {
        String event = data.getDomain() + "." + data.getTable();
        log.debug("send message,table:{},sql:{}", (Object)data.getTable(), (Object)data.getSql());
        this.dataSyncOut.output().send(MessageBuilder.withPayload((Object)KryoUtils.writeToString((Object)data)).build());
    }
}

