/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.route.util;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataSourceUtil {
    private static final String SET_METHOD_PREFIX = "set";
    private static final Collection<Class<?>> GENERAL_CLASS_TYPE;
    private static final Logger log;

    private DataSourceUtil() {
    }

    public static DataSource getDataSource(String dataSourceClassName, Map<String, Object> dataSourceProperties) throws ReflectiveOperationException {
        DataSource result = (DataSource)Class.forName(dataSourceClassName).newInstance();
        for (Map.Entry<String, Object> entry : dataSourceProperties.entrySet()) {
            DataSourceUtil.callSetterMethod(result, DataSourceUtil.getSetterMethodName(entry.getKey()), null == entry.getValue() ? null : entry.getValue().toString());
        }
        return result;
    }

    private static String getSetterMethodName(String propertyName) {
        if (propertyName.contains("-")) {
            return CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, "set-" + propertyName);
        }
        return SET_METHOD_PREFIX + String.valueOf(propertyName.charAt(0)).toUpperCase() + propertyName.substring(1, propertyName.length());
    }

    private static void callSetterMethod(DataSource dataSource, String methodName, String setterValue) {
        for (Class<?> each : GENERAL_CLASS_TYPE) {
            try {
                Method method = dataSource.getClass().getMethod(methodName, each);
                if (Boolean.TYPE == each || Boolean.class == each) {
                    method.invoke((Object)dataSource, Boolean.valueOf(setterValue));
                } else if (Integer.TYPE == each || Integer.class == each) {
                    method.invoke((Object)dataSource, Integer.parseInt(setterValue));
                } else if (Long.TYPE == each || Long.class == each) {
                    method.invoke((Object)dataSource, Long.parseLong(setterValue));
                } else {
                    method.invoke((Object)dataSource, setterValue);
                }
                return;
            }
            catch (ReflectiveOperationException ignored) {
                log.warn("callSetterMethod exception message: {}", (Object)ignored.getMessage());
            }
        }
    }

    static {
        log = LoggerFactory.getLogger(DataSourceUtil.class);
        GENERAL_CLASS_TYPE = Sets.newHashSet((Object[])new Class[]{Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, String.class});
    }
}

