/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.route.jdbc.adapter;

import cn.com.yusys.yusp.commons.route.jdbc.adapter.executor.ForceExecuteCallback;
import cn.com.yusys.yusp.commons.route.jdbc.adapter.executor.ForceExecuteTemplate;
import cn.com.yusys.yusp.commons.route.jdbc.unsupported.AbstractUnsupportedOperationConnection;
import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionAdapter
extends AbstractUnsupportedOperationConnection {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConnectionAdapter.class);
    private final Multimap<String, Connection> cachedConnections = LinkedHashMultimap.create();
    private final ForceExecuteTemplate<Connection> forceExecuteTemplate = new ForceExecuteTemplate();
    private final ForceExecuteTemplate<Map.Entry<String, Connection>> forceExecuteTemplateForClose = new ForceExecuteTemplate();
    private boolean autoCommit = true;
    private boolean readOnly = true;
    private volatile boolean closed;
    private int transactionIsolation = 1;

    public Multimap<String, Connection> getCachedConnections() {
        return this.cachedConnections;
    }

    public ForceExecuteTemplate<Connection> getForceExecuteTemplate() {
        return this.forceExecuteTemplate;
    }

    public ForceExecuteTemplate<Map.Entry<String, Connection>> getForceExecuteTemplateForClose() {
        return this.forceExecuteTemplateForClose;
    }

    protected AbstractConnectionAdapter() {
    }

    public final Connection getConnection(String dataSourceName) throws SQLException {
        return this.getConnections(dataSourceName, 1).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Connection> getConnections(String dataSourceName, int connectionSize) throws SQLException {
        List<Connection> result;
        Collection connections;
        DataSource dataSource = this.getDataSourceMap().get(dataSourceName);
        Preconditions.checkState((null != dataSource ? 1 : 0) != 0, (String)"Missing the data source name: '%s'", (Object)dataSourceName);
        Multimap<String, Connection> multimap = this.cachedConnections;
        synchronized (multimap) {
            connections = this.cachedConnections.get((Object)dataSourceName);
        }
        if (connections.size() >= connectionSize) {
            result = new ArrayList(connections).subList(0, connectionSize);
        } else {
            if (!connections.isEmpty()) {
                result = new ArrayList(connectionSize);
                result.addAll(connections);
                List<Connection> newConnections = this.createConnections0(dataSourceName, dataSource, connectionSize - connections.size());
                result.addAll(newConnections);
                Multimap<String, Connection> multimap2 = this.cachedConnections;
                synchronized (multimap2) {
                    this.cachedConnections.putAll((Object)dataSourceName, newConnections);
                }
            }
            result = new ArrayList<Connection>(this.createConnections0(dataSourceName, dataSource, connectionSize));
            Multimap<String, Connection> multimap3 = this.cachedConnections;
            synchronized (multimap3) {
                this.cachedConnections.putAll((Object)dataSourceName, result);
            }
        }
        return result;
    }

    private List<Connection> createConnections0(String dataSourceName, DataSource dataSource, int connectionSize) throws SQLException {
        if (1 == connectionSize) {
            Connection connection = this.createConnection(dataSourceName, dataSource);
            this.replayMethodsInvocation(connection);
            return Collections.singletonList(connection);
        }
        return this.createConnections(dataSourceName, dataSource, connectionSize);
    }

    private List<Connection> createConnections(String dataSourceName, DataSource dataSource, int connectionSize) throws SQLException {
        ArrayList<Connection> result = new ArrayList<Connection>(connectionSize);
        for (int i = 0; i < connectionSize; ++i) {
            try {
                Connection connection = this.createConnection(dataSourceName, dataSource);
                this.replayMethodsInvocation(connection);
                result.add(connection);
                continue;
            }
            catch (SQLException ex) {
                for (Connection each : result) {
                    each.close();
                }
                throw new SQLException(String.format("Could't get %d connections one time, partition succeed connection(%d) have released!", connectionSize, result.size()), ex);
            }
        }
        return result;
    }

    protected abstract Connection createConnection(String var1, DataSource var2) throws SQLException;

    protected abstract Map<String, DataSource> getDataSourceMap();

    @Override
    public final boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
        this.setAutoCommitForLocalTransaction(autoCommit);
    }

    private void setAutoCommitForLocalTransaction(final boolean autoCommit) throws SQLException {
        this.recordMethodInvocation(Connection.class, "setAutoCommit", new Class[]{Boolean.TYPE}, new Object[]{autoCommit});
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), new ForceExecuteCallback<Connection>(){

            @Override
            public void execute(Connection connection) throws SQLException {
                connection.setAutoCommit(autoCommit);
            }
        });
    }

    protected abstract Connection getMainConnection() throws SQLException;

    @Override
    public final Savepoint setSavepoint() throws SQLException {
        return this.getMainConnection().setSavepoint();
    }

    @Override
    public final Savepoint setSavepoint(String name) throws SQLException {
        return this.getMainConnection().setSavepoint(name);
    }

    @Override
    public final void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.getMainConnection().releaseSavepoint(savepoint);
    }

    @Override
    public final void rollback(Savepoint savepoint) throws SQLException {
        this.getMainConnection().rollback(savepoint);
    }

    @Override
    public void commit() throws SQLException {
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), new ForceExecuteCallback<Connection>(){

            @Override
            public void execute(Connection connection) throws SQLException {
                connection.commit();
            }
        });
    }

    @Override
    public void rollback() throws SQLException {
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), new ForceExecuteCallback<Connection>(){

            @Override
            public void execute(Connection connection) throws SQLException {
                connection.rollback();
            }
        });
    }

    @Override
    public final void close() throws SQLException {
        this.closed = true;
        try {
            this.forceExecuteTemplateForClose.execute(this.cachedConnections.entries(), new ForceExecuteCallback<Map.Entry<String, Connection>>(){

                @Override
                public void execute(Map.Entry<String, Connection> cachedConnections) throws SQLException {
                    cachedConnections.getValue().close();
                }
            });
        }
        finally {
            this.cachedConnections.clear();
        }
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public final boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public final void setReadOnly(final boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
        this.recordMethodInvocation(Connection.class, "setReadOnly", new Class[]{Boolean.TYPE}, new Object[]{readOnly});
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), new ForceExecuteCallback<Connection>(){

            @Override
            public void execute(Connection connection) throws SQLException {
                connection.setReadOnly(readOnly);
            }
        });
    }

    @Override
    public final int getTransactionIsolation() throws SQLException {
        if (this.cachedConnections.values().isEmpty()) {
            return this.transactionIsolation;
        }
        return ((Connection)this.cachedConnections.values().iterator().next()).getTransactionIsolation();
    }

    @Override
    public final void setTransactionIsolation(final int level) throws SQLException {
        this.transactionIsolation = level;
        this.recordMethodInvocation(Connection.class, "setTransactionIsolation", new Class[]{Integer.TYPE}, new Object[]{level});
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), new ForceExecuteCallback<Connection>(){

            @Override
            public void execute(Connection connection) throws SQLException {
                connection.setTransactionIsolation(level);
            }
        });
    }

    @Override
    public final SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public final int getHoldability() {
        return 2;
    }

    @Override
    public final void setHoldability(int holdability) {
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.cachedConnections.keySet().stream().map(this::getHealthCheckConnection).allMatch(conn -> this.connectionValid((Connection)conn, timeout));
    }

    protected Connection getHealthCheckConnection(String dataSourceName) {
        try {
            return this.getConnection(dataSourceName);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected boolean connectionValid(Connection connection, int timeout) {
        try {
            return Objects.nonNull(connection) && connection.isValid(timeout);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

