/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.route.jdbc.core.datasource;

import cn.com.yusys.yusp.commons.route.jdbc.unsupported.AbstractUnsupportedOperationDataSource;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSourceAdapter
extends AbstractUnsupportedOperationDataSource
implements AutoCloseable {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, DataSource> dataSourceMap;
    private PrintWriter logWriter = new PrintWriter(System.out);

    public AbstractDataSourceAdapter(Map<String, DataSource> dataSourceMap) throws SQLException {
        this.dataSourceMap = dataSourceMap;
    }

    @Override
    public final java.util.logging.Logger getParentLogger() {
        return java.util.logging.Logger.getLogger("global");
    }

    @Override
    public final Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public final void close() throws Exception {
        this.close(this.dataSourceMap.keySet());
    }

    public void close(Collection<String> dataSourceNames) throws Exception {
        for (String each : dataSourceNames) {
            this.close(this.dataSourceMap.get(each));
        }
    }

    private void close(DataSource dataSource) {
        try {
            Method method = dataSource.getClass().getDeclaredMethod("close", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)dataSource, new Object[0]);
        }
        catch (ReflectiveOperationException ignored) {
            this.log.error("AbstractDataSourceAdapter close error, message:{}", (Object)ignored.getMessage());
        }
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }
}

