/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.route.mybatis;

import cn.com.yusys.yusp.commons.route.jdbc.core.connection.DataRouteHandler;
import cn.com.yusys.yusp.commons.route.mybatis.DataRoutePropertiesDto;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.Properties;
import java.util.Set;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class DataRouteNameInterceptor
implements Interceptor {
    private DataRoutePropertiesDto dataRouteDto;
    private AntPathMatcher matcher = new AntPathMatcher();
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaObjectHandler = SystemMetaObject.forObject(DataRouteNameInterceptor.realTarget(statementHandler));
        MappedStatement mappedStatement = (MappedStatement)metaObjectHandler.getValue("delegate.mappedStatement");
        String sqlId = mappedStatement.getId();
        String dataSourceName = DataRouteHandler.DataSourceName.get();
        if (null == dataSourceName || "".equals(dataSourceName)) {
            dataSourceName = this.isMulti(sqlId);
            if (null != dataSourceName) {
                DataRouteHandler.DataSourceName.set(dataSourceName);
            } else {
                DataRouteHandler.DataSourceName.set(this.dataRouteDto.getDefaultDataSourceName());
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("set dataSourceName [{} -> {}]", (Object)sqlId, (Object)dataSourceName);
        }
        Object re = invocation.proceed();
        DataRouteHandler.DataSourceName.remove();
        return re;
    }

    private String isMulti(String sqlId) {
        Set<String> namespaces = this.dataRouteDto.getNamespaces().keySet();
        for (String namespace : namespaces) {
            if (!this.matcher.match(namespace, sqlId)) continue;
            return this.dataRouteDto.getNamespaces().get(namespace);
        }
        return null;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public static <T> T realTarget(Object target) {
        if (Proxy.isProxyClass(target.getClass())) {
            MetaObject metaObject = SystemMetaObject.forObject((Object)target);
            return DataRouteNameInterceptor.realTarget(metaObject.getValue("h.target"));
        }
        return (T)target;
    }

    public DataRoutePropertiesDto getDataSourceRouteDto() {
        return this.dataRouteDto;
    }

    public void setDataSourceRouteDto(DataRoutePropertiesDto dataSourceRouteDto) {
        this.dataRouteDto = dataSourceRouteDto;
    }
}

